import QtQuick
import QtQuick.Controls
import QtQuick3D
import QtQuick.Layouts

Button {
    id: selectionBtn
    property string selection: "this.text"

    width: 580
    height: 88
    text: qsTr("Button")
    checked: selection === text
    icon.source: "DemoUI/CloseBtn_X.png"
    font.pointSize: 20
    font.family: "Archivo"
    icon.color: "#ffffff"
    Layout.preferredHeight: 88
    Layout.preferredWidth: 580
    Layout.alignment: Qt.AlignLeft | Qt.AlignTop
    padding: 0
    display: AbstractButton.IconOnly
    background: Rectangle {
        radius: 8
        anchors.fill: parent
        opacity: 1
        color: selectionBtn.pressed ? "#B8B8B9" : (selectionBtn.hovered ? "#5C5C5D" : (selectionBtn.checked ? "#3D3D3E" : "#222222"))
    }

    contentItem: Item {
        id: itemGroup
        Layout.fillHeight: true
        Layout.fillWidth: true

        Label {
            text: selectionBtn.text
            anchors.left: parent.left
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            font.pixelSize: 20
            horizontalAlignment: Text.AlignLeft
            color: "#ffffff"
            verticalAlignment: Text.AlignVCenter
            anchors.leftMargin: 108
        }
        Rectangle {
            id: rectangle
            color: "#5c5c5d"
            radius: 36
            border.width: 0
            anchors.left: parent.left
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.topMargin: 8
            anchors.bottomMargin: 8
            anchors.rightMargin: 500
            anchors.leftMargin: 8

            Image {
                anchors.verticalCenter: parent.verticalCenter
                anchors.top: parent.top
                source: selectionBtn.icon.source
                anchors.horizontalCenter: parent.horizontalCenter
                autoTransform: false
                fillMode: Image.Pad
            }
        }

        Image {
            anchors.verticalCenter: parent.verticalCenter
            anchors.right: parent.right
            anchors.top: parent.top
            horizontalAlignment: Image.AlignRight
            source: selectionBtn.checked ? "images/CheckFilledVector.png" : "images/CheckEmptyVector.png"
            anchors.rightMargin: 30
            anchors.horizontalCenter: parent.horizontalCenter
            autoTransform: false
            fillMode: Image.Pad
        }
    }
}

/*##^##
Designer {
    D{i:0}D{i:8;cameraSpeed3d:25;cameraSpeed3dMultiplier:1}
}
##^##*/
