
// Created with Qt Design Studio (version 4.7.0), Thu Nov 14 16:08:12 2024
// Do not manually edit this file, it will be overwritten if effect is modified in Qt Design Studio.

import QtQuick
import QtQuick.Layouts
import HelperWidgets
import StudioTheme as StudioTheme

Column {

    Section {
        caption: "General"
        width: parent.width

        SectionLayout {
            PropertyLabel {
                text: "Extra Margin"
                tooltip: "This property specifies how much of extra space is reserved for the effect outside the parent geometry."
            }

            SecondColumnLayout {
                SpinBox {
                    minimumValue: 0
                    maximumValue: 1000
                    decimals: 0
                    stepSize: 1
                    sliderIndicatorVisible: true
                    backendValue: backendValues.extraMargin
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }
                ExpandingSpacer {}
            }
        }
    }

    Section {
        caption: "Blur Helper"
        width: parent.width

        SectionLayout {

            PropertyLabel {
                text: "Multiplier"
                tooltip: "This property defines a multiplier for extending the blur radius.\n\nBy default, the property is set to 0.0 (not multiplied). Incresing the multiplier extends the blur radius, but decreases the blur quality. This is more performant option for a bigger blur radius than Max Blur Level as it doesn't increase the amount of texture lookups.\n\nNote: This affects to both blur and shadow effects."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 2
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.blurMultiplier
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }
        }
    }

    Section {
        caption: "Glow"
        width: parent.width

        SectionLayout {

            PropertyLabel {
                text: "Blend Mode"
                tooltip: "Blending mode for the glow effect. 0 = Additive, 1 = Screen, 2 = Replace."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 2
                    decimals: 0
                    stepSize: 1
                    sliderIndicatorVisible: true
                    backendValue: backendValues.glowBlendMode
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }
    
                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Blur Amount"
                tooltip: "This value defines the softness of the glow. Values are between 0..1."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.glowBlurAmount
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Bloom"
                tooltip: "This value defines the bloom strength of the glow. Suitable values are between 0..2."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 2
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.glowBloom
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Max Brightness"
                tooltip: "Sets the maximum brightness of the glow."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.glowMaxBrightness
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }
        }
    }

    Section {
        caption: "Swirl"
        width: parent.width

        SectionLayout {

            PropertyLabel {
                text: "Wave Length"
                tooltip: "Sets how tightly or loosely the swirls wrap around the center point."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 10
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.swirlWaveLength
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Amplitude"
                tooltip: "Sets the intensity of the swirl. This defines how far the graphics deviate from the center point."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 0.5
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.swirlAmplitude
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Phase"
                tooltip: "Sets the starting point of the swirl."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    sliderIndicatorVisible: true
                    backendValue: backendValues.swirlPhase
                    implicitWidth: StudioTheme.Values.singleControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                ExpandingSpacer {}
            }

            PropertyLabel {
                text: "Center Point"
                tooltip: "Sets the point around which the swirl effect revolves. 0.5, 0.5 is the center."
            }

            SecondColumnLayout {

                SpinBox {
                    minimumValue: 0
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    backendValue: backendValues.swirlCenterPoint_x
                    implicitWidth: StudioTheme.Values.twoControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                Spacer { implicitWidth: StudioTheme.Values.controlLabelGap }

                ControlLabel {
                    text: "X"
                }
                Spacer { implicitWidth: StudioTheme.Values.controlGap }

                SpinBox {
                    minimumValue: 0
                    maximumValue: 1
                    decimals: 2
                    stepSize: .01
                    backendValue: backendValues.swirlCenterPoint_y
                    implicitWidth: StudioTheme.Values.twoControlColumnWidth
                                   + StudioTheme.Values.actionIndicatorWidth
                }

                Spacer { implicitWidth: StudioTheme.Values.controlLabelGap }

                ControlLabel {
                    text: "Y"
                }

                ExpandingSpacer {}
            }
        }
    }
}
