import QtQuick
import QtQuick.Controls

Button {
    id: root

    property alias iconText: _text.text
    property alias iconRotation: _text.rotation

    width: 60
    height: 32
    font.pixelSize: 30
    checkable: true
    background: Item {}
    contentItem: Text {
        id: _text

        anchors.horizontalCenter: parent.horizontalCenter
        anchors.verticalCenter: parent.verticalCenter
        text: qsTr(">")
        color: "#99a3a5"
        font.pixelSize: 30
        horizontalAlignment: Text.AlignHCenter
        verticalAlignment: Text.AlignVCenter
    }

    states: [
        State {
            name: "pressed"
            when: root.pressed

            PropertyChanges {
                target: _text
                color: "#23784d"
            }
        },

        State {
            name: "hovered"
            when: root.hovered

            PropertyChanges {
                target: _text
                color: "#2cde85"
            }
        }
    ]
}
