import QtQuick
import QtQuick.Controls
import QtQuick.Timeline

Rectangle {
    id: splashScreen
    width: 800
    height: 480
    opacity: 1
    color: "transparent"

    Image {
        id: bg
        x: 0
        y: 0
        source: "assets/bg.png"
    }

    Image {
        id: slogan
        x: 154
        y: 211
        source: "assets/slogan.png"
    }

    Image {
        id: qtLogo
        x: 245
        y: 354
        source: "assets/qtLogo.png"
    }

    Image {
        id: speedtrekLogo
        x: 88
        y: 109
        source: "assets/speedtrekLogo.png"
    }

    Timeline {
        id: timeline
        animations: [
            TimelineAnimation {
                id: timelineAnimation
                running: true
                loops: 1
                duration: 5000
                to: 1000
                from: 0
            }
        ]
        startFrame: 0
        endFrame: 1000
        enabled: true

        KeyframeGroup {
            target: slogan
            property: "x"
            Keyframe {
                value: 254
                frame: 0
            }

            Keyframe {
                value: 154
                frame: 200
            }
        }

        KeyframeGroup {
            target: slogan
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 200
            }
        }

        KeyframeGroup {
            target: qtLogo
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 0
                frame: 200
            }

            Keyframe {
                value: 1
                frame: 400
            }
        }

        KeyframeGroup {
            target: speedtrekLogo
            property: "x"
            Keyframe {
                value: -12
                frame: 0
            }

            Keyframe {
                value: 88
                frame: 200
            }
        }

        KeyframeGroup {
            target: speedtrekLogo
            property: "opacity"
            Keyframe {
                value: 0
                frame: 0
            }

            Keyframe {
                value: 1
                frame: 200
            }
        }

        KeyframeGroup {
            target: qtLogo
            property: "y"
            Keyframe {
                value: 354
                frame: 200
            }

            Keyframe {
                value: 334
                frame: 400
            }
        }

        KeyframeGroup {
            target: splashScreen
            property: "opacity"
            Keyframe {
                value: 1
                frame: 800
            }

            Keyframe {
                value: 0
                frame: 1000
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;uuid:"a9b4123f-46a4-599b-90db-2170e8c4b9e7"}D{i:1;uuid:"e54114c9-5d5a-590d-8d6f-9c7feb0ad7e6"}
D{i:2;uuid:"26360cf2-6404-5a94-970e-bf3a34435554"}D{i:3;uuid:"7a2143aa-7d15-5ba6-bb5a-e73f59068a71"}
D{i:4;uuid:"0e5e2bd4-cf64-548a-a81d-1fbd4b780c36"}
}
##^##*/

