import highendivisystem 1.0
import QtQuick 2.15
import QtQuick3D 1.15
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6
import Quick3DAssets.CarLights 1.0
import QtQuick3D.Materials 1.14
import QtQuick3D.Materials 1.15

CustomMaterial {
    id: rearLightMat
    property alias tInputBrake: brake
    property alias tInputTurn: turn
    property alias tInputBase: base
    property alias tInputLight: light
    property real lightOn: 0
    property real brakeOn: 0
    property real turnOn: 0
    passes: renderPass
    shaderInfo: shaderInformation
    ShaderInfo {
        id: shaderInformation
        version: "330"
        type: "GLSL"
    }
    
    Pass {
        id: renderPass
        shaders: [vertShader, fragShader]
    }
    
    Shader {
        id: vertShader
        shader: "rearlight.vert"
        stage: Shader.Vertex
    }
    
    Shader {
        id: fragShader
        shader: "rearlight.frag"
        stage: Shader.Fragment
    }
    
    TextureInput {
        id: base
        texture: texturebase
    }
    
    TextureInput {
        id: light
        texture: texturerearlight
    }
    
    TextureInput {
        id: turn
        texture: texturerearturn
    }
    
    TextureInput {
        id: brake
        texture: texturebrake
    }
    
    Texture {
        id: texturebase
        source: "Map3.jpg"
    }
    
    Texture {
        id: texturerearlight
        source: "rearlight.jpg"
    }
    
    Texture {
        id: texturerearturn
        source: "rearturnsignal.jpg"
    }
    
    Texture {
        id: texturebrake
        source: "brakelight.jpg"
    }
}
