/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
}

var Dir = new function ()
{
    this.toNativeSeparator = function (path)
    {
        path = path.replace(/\/\//g, '/');
        if (systemInfo.productType === "windows")
            return path.replace(/\//g, '\\');
        return path;
    }
};

Component.prototype.createOperations = function()
{
    component.createOperations();

    // prepare Qt/Conan profile for this target configuration
    var qtVersionPath = "@TargetDir@" + "/6.0.1";
    var profileFileBasePath = "@TargetDir@/Tools/Conan/profiles";
    var profileFile_x86 = profileFileBasePath + "/qt-6.0.1-android-x86";
    var profileFile_x86_64 = profileFileBasePath + "/qt-6.0.1-android-x86_64";
    var profileFile_armeabi_v7a = profileFileBasePath + "/qt-6.0.1-android-armeabi-v7a";
    var profileFile_armv64_v8a = profileFileBasePath + "/qt-6.0.1-android-armv64_v8a";

    try {
        console.log("Preparing Conan profile file: " + profileFile_x86);
        component.addOperation("Replace", profileFile_x86, "%QT_VERSION_PATH%", Dir.toNativeSeparator(qtVersionPath));
        console.log("Preparing Conan profile file: " + profileFile_x86_64);
        component.addOperation("Replace", profileFile_x86_64, "%QT_VERSION_PATH%", Dir.toNativeSeparator(qtVersionPath));
        console.log("Preparing Conan profile file: " + profileFile_armeabi_v7a);
        component.addOperation("Replace", profileFile_armeabi_v7a, "%QT_VERSION_PATH%", Dir.toNativeSeparator(qtVersionPath));
        console.log("Preparing Conan profile file: " + profileFile_armv64_v8a);
        component.addOperation("Replace", profileFile_armv64_v8a, "%QT_VERSION_PATH%", Dir.toNativeSeparator(qtVersionPath));
    } catch(e) {
        console.log("Conan profile file not available!");
    }
}

