/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc.antlr4;

import com.github.javaparser.StaticJavaParser;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.groovy.antlr.GroovydocVisitor;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyMemberDoc;
import org.codehaus.groovy.groovydoc.GroovyMethodDoc;
import org.codehaus.groovy.groovydoc.GroovyProgramElementDoc;
import org.codehaus.groovy.tools.groovydoc.GroovyDocParserI;
import org.codehaus.groovy.tools.groovydoc.LinkArgument;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyFieldDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyMethodDoc;
import org.codehaus.groovy.tools.groovydoc.antlr4.GroovydocJavaVisitor;
import org.codehaus.groovy.tools.shell.util.Logger;

public class GroovyDocParser
implements GroovyDocParserI {
    private final List<LinkArgument> links;
    private final Properties properties;
    private final Logger log = Logger.create(GroovyDocParser.class);

    public GroovyDocParser(List<LinkArgument> links, Properties properties) {
        this.links = links;
        this.properties = properties;
    }

    @Override
    public Map<String, GroovyClassDoc> getClassDocsFromSingleSource(String packagePath, String file, String src) throws RuntimeException {
        if (file.indexOf(".java") > 0) {
            return this.parseJava(packagePath, file, src);
        }
        if (file.indexOf(".sourcefile") > 0) {
            return this.parseJava(packagePath, file, src);
        }
        return this.parseGroovy(packagePath, file, src);
    }

    private Map<String, GroovyClassDoc> parseJava(String packagePath, String file, String src) throws RuntimeException {
        GroovydocJavaVisitor visitor = new GroovydocJavaVisitor(packagePath, this.links);
        try {
            visitor.visit(StaticJavaParser.parse((String)src), null);
        }
        catch (Throwable t) {
            System.err.println("Attempting to ignore error parsing Java source file: " + packagePath + "/" + file);
            System.err.println("Consider reporting the error to the Groovy project: https://issues.apache.org/jira/browse/GROOVY");
            System.err.println("... or directly to the JavaParser project: https://github.com/javaparser/javaparser/issues");
            System.err.println("Error: " + t.getMessage());
        }
        return visitor.getGroovyClassDocs();
    }

    private Map<String, GroovyClassDoc> parseGroovy(String packagePath, String file, String src) throws RuntimeException {
        CompilerConfiguration config = new CompilerConfiguration();
        config.getOptimizationOptions().put("groovydoc", true);
        CompilationUnit compUnit = new CompilationUnit(config);
        SourceUnit unit = new SourceUnit(file, src, config, null, new ErrorCollector(config));
        compUnit.addSource(unit);
        int phase = 3;
        if (this.properties.containsKey("phaseOverride")) {
            String raw = this.properties.getProperty("phaseOverride");
            try {
                phase = Integer.parseInt(raw);
            }
            catch (NumberFormatException ignore) {
                switch (raw = raw.toUpperCase()) {
                    case "CONVERSION": {
                        phase = 3;
                        break;
                    }
                    case "SEMANTIC_ANALYSIS": {
                        phase = 4;
                        break;
                    }
                    case "CANONICALIZATION": {
                        phase = 5;
                        break;
                    }
                    case "INSTRUCTION_SELECTION": {
                        phase = 6;
                        break;
                    }
                    case "CLASS_GENERATION": {
                        phase = 7;
                        break;
                    }
                    default: {
                        System.err.println("Ignoring unrecognised or unsuitable phase and keeping default");
                    }
                }
            }
        }
        compUnit.compile(phase);
        ModuleNode root = unit.getAST();
        GroovydocVisitor visitor = new GroovydocVisitor(unit, packagePath, this.links, this.properties);
        root.getClasses().stream().forEach(clazz -> visitor.visitClass((ClassNode)clazz));
        return visitor.getGroovyClassDocs();
    }

    private void replaceTags(SimpleGroovyClassDoc sgcd) {
        sgcd.setRawCommentText(sgcd.replaceTags(sgcd.getRawCommentText()));
        for (GroovyMethodDoc groovyMethodDoc : sgcd.methods()) {
            SimpleGroovyMethodDoc sgmd = (SimpleGroovyMethodDoc)groovyMethodDoc;
            sgmd.setRawCommentText(sgcd.replaceTags(sgmd.getRawCommentText()));
        }
        for (GroovyMemberDoc groovyMemberDoc : sgcd.isEnum() ? sgcd.enumConstants() : sgcd.fields()) {
            SimpleGroovyFieldDoc sgfd = (SimpleGroovyFieldDoc)groovyMemberDoc;
            sgfd.setRawCommentText(sgcd.replaceTags(sgfd.getRawCommentText()));
        }
        for (GroovyProgramElementDoc groovyProgramElementDoc : sgcd.innerClasses()) {
            this.replaceTags((SimpleGroovyClassDoc)groovyProgramElementDoc);
        }
    }
}

