/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.services.IServiceLocator;

public class CompareHandlerService {
    private final List fActivations = new ArrayList();
    private final Expression fExpression;
    private ICompareContainer fContainer;
    private boolean fDisposed;
    private List fPaneActivations = new ArrayList();
    private IHandlerService fHandlerService;
    static /* synthetic */ Class class$0;

    public static CompareHandlerService createFor(ICompareContainer container, Shell shell) {
        IHandlerService service;
        IServiceLocator serviceLocator = container.getServiceLocator();
        if (serviceLocator != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((service = (IHandlerService)serviceLocator.getService((Class)clazz)) != null) {
                return new CompareHandlerService(container, null);
            }
        }
        if (container.getWorkbenchPart() == null && shell != null) {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((service = (IHandlerService)iWorkbench.getService((Class)clazz)) != null) {
                ActiveShellExpression e = new ActiveShellExpression(shell);
                return new CompareHandlerService(container, (Expression)e);
            }
        }
        return new CompareHandlerService(null, null);
    }

    private CompareHandlerService(ICompareContainer container, Expression expression) {
        this.fContainer = container;
        this.fExpression = expression;
        this.initialize();
    }

    public void registerAction(IAction action, String commandId) {
        IHandlerService handlerService = this.getHandlerService();
        if (handlerService == null) {
            return;
        }
        action.setActionDefinitionId(commandId);
        IHandlerActivation activation = this.fExpression == null ? handlerService.activateHandler(commandId, (IHandler)new ActionHandler(action)) : handlerService.activateHandler(commandId, (IHandler)new ActionHandler(action), this.fExpression);
        if (activation != null) {
            this.fActivations.add(activation);
        }
    }

    private IHandlerService getHandlerService() {
        if (this.fDisposed) {
            return null;
        }
        return this.fHandlerService;
    }

    private void initialize() {
        if (this.fHandlerService == null) {
            IHandlerService service;
            IServiceLocator serviceLocator = this.fContainer.getServiceLocator();
            if (serviceLocator != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((service = (IHandlerService)serviceLocator.getService((Class)clazz)) != null) {
                    this.fHandlerService = service;
                }
            }
            if (this.fHandlerService == null && this.fContainer.getWorkbenchPart() == null && this.fExpression != null) {
                IWorkbench iWorkbench = PlatformUI.getWorkbench();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((service = (IHandlerService)iWorkbench.getService((Class)clazz)) != null) {
                    this.fHandlerService = service;
                }
            }
        }
    }

    public void setGlobalActionHandler(String actionId, IAction actionHandler) {
        IHandlerService service;
        IActionBars bars = this.getActionBars();
        if (bars != null) {
            bars.setGlobalActionHandler(actionId, actionHandler);
            return;
        }
        if (this.fExpression != null && actionHandler != null && actionHandler.getActionDefinitionId() != null && (service = this.getHandlerService()) != null) {
            IHandlerActivation activation = service.activateHandler(actionHandler.getActionDefinitionId(), (IHandler)new ActionHandler(actionHandler), this.fExpression);
            this.fPaneActivations.add(activation);
            return;
        }
        if (actionHandler != null) {
            actionHandler.setActionDefinitionId(null);
        }
    }

    private void updateActionBars() {
        IActionBars bars = this.getActionBars();
        if (bars != null) {
            bars.updateActionBars();
        }
    }

    private void clearPaneActionHandlers() {
        IHandlerService service;
        if (!this.fPaneActivations.isEmpty() && (service = this.getHandlerService()) != null) {
            service.deactivateHandlers((Collection)this.fPaneActivations);
            this.fPaneActivations.clear();
        }
    }

    private IActionBars getActionBars() {
        return this.fContainer.getActionBars();
    }

    public void dispose() {
        this.clearPaneActionHandlers();
        IHandlerService service = this.getHandlerService();
        if (service == null) {
            return;
        }
        service.deactivateHandlers((Collection)this.fActivations);
        this.fActivations.clear();
        this.fDisposed = true;
    }

    public void updatePaneActionHandlers(Runnable runnable) {
        this.clearPaneActionHandlers();
        runnable.run();
        this.updateActionBars();
    }
}

