/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.v2.runtime.output;

import com.sun.xml.internal.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.internal.bind.v2.runtime.XMLSerializer;
import com.sun.xml.internal.bind.v2.runtime.output.NamespaceContextImpl;
import com.sun.xml.internal.bind.v2.runtime.output.Pcdata;
import com.sun.xml.internal.bind.v2.runtime.output.XmlOutput;
import com.sun.xml.internal.bind.v2.runtime.output.XmlOutputAbstractImpl;
import com.sun.xml.internal.bind.v2.util.ClassLoaderRetriever;
import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.SAXException;

public class XMLStreamWriterOutput
extends XmlOutputAbstractImpl {
    private final XMLStreamWriter out;
    protected final char[] buf = new char[256];
    private static final Class FI_STAX_WRITER_CLASS = XMLStreamWriterOutput.initFIStAXWriterClass();
    private static final Constructor<? extends XmlOutput> FI_OUTPUT_CTOR = XMLStreamWriterOutput.initFastInfosetOutputClass();
    private static final Class STAXEX_WRITER_CLASS = XMLStreamWriterOutput.initStAXExWriterClass();
    private static final Constructor<? extends XmlOutput> STAXEX_OUTPUT_CTOR = XMLStreamWriterOutput.initStAXExOutputClass();

    public static XmlOutput create(XMLStreamWriter xMLStreamWriter, JAXBContextImpl jAXBContextImpl) {
        Class<?> clazz = xMLStreamWriter.getClass();
        if (clazz == FI_STAX_WRITER_CLASS) {
            try {
                return FI_OUTPUT_CTOR.newInstance(xMLStreamWriter, jAXBContextImpl);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (STAXEX_WRITER_CLASS != null && STAXEX_WRITER_CLASS.isAssignableFrom(clazz)) {
            try {
                return STAXEX_OUTPUT_CTOR.newInstance(xMLStreamWriter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new XMLStreamWriterOutput(xMLStreamWriter);
    }

    protected XMLStreamWriterOutput(XMLStreamWriter xMLStreamWriter) {
        this.out = xMLStreamWriter;
    }

    @Override
    public void startDocument(XMLSerializer xMLSerializer, boolean bl, int[] nArray, NamespaceContextImpl namespaceContextImpl) throws IOException, SAXException, XMLStreamException {
        super.startDocument(xMLSerializer, bl, nArray, namespaceContextImpl);
        if (!bl) {
            this.out.writeStartDocument();
        }
    }

    @Override
    public void endDocument(boolean bl) throws IOException, SAXException, XMLStreamException {
        if (!bl) {
            this.out.writeEndDocument();
            this.out.flush();
        }
        super.endDocument(bl);
    }

    @Override
    public void beginStartTag(int n, String string) throws IOException, XMLStreamException {
        this.out.writeStartElement(this.nsContext.getPrefix(n), string, this.nsContext.getNamespaceURI(n));
        NamespaceContextImpl.Element element = this.nsContext.getCurrent();
        if (element.count() > 0) {
            for (int i = element.count() - 1; i >= 0; --i) {
                String string2 = element.getNsUri(i);
                if (string2.length() == 0 && element.getBase() == 1) continue;
                this.out.writeNamespace(element.getPrefix(i), string2);
            }
        }
    }

    @Override
    public void attribute(int n, String string, String string2) throws IOException, XMLStreamException {
        if (n == -1) {
            this.out.writeAttribute(string, string2);
        } else {
            this.out.writeAttribute(this.nsContext.getPrefix(n), this.nsContext.getNamespaceURI(n), string, string2);
        }
    }

    @Override
    public void endStartTag() throws IOException, SAXException {
    }

    @Override
    public void endTag(int n, String string) throws IOException, SAXException, XMLStreamException {
        this.out.writeEndElement();
    }

    @Override
    public void text(String string, boolean bl) throws IOException, SAXException, XMLStreamException {
        if (bl) {
            this.out.writeCharacters(" ");
        }
        this.out.writeCharacters(string);
    }

    @Override
    public void text(Pcdata pcdata, boolean bl) throws IOException, SAXException, XMLStreamException {
        int n;
        if (bl) {
            this.out.writeCharacters(" ");
        }
        if ((n = pcdata.length()) < this.buf.length) {
            pcdata.writeTo(this.buf, 0);
            this.out.writeCharacters(this.buf, 0, n);
        } else {
            this.out.writeCharacters(pcdata.toString());
        }
    }

    private static Class initFIStAXWriterClass() {
        try {
            ClassLoader classLoader = ClassLoaderRetriever.getClassLoader();
            Class<?> clazz = Class.forName("com.sun.xml.internal.org.jvnet.fastinfoset.stax.LowLevelFastInfosetStreamWriter", true, classLoader);
            Class<?> clazz2 = classLoader.loadClass("com.sun.xml.internal.fastinfoset.stax.StAXDocumentSerializer");
            if (clazz.isAssignableFrom(clazz2)) {
                return clazz2;
            }
            return null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Constructor<? extends XmlOutput> initFastInfosetOutputClass() {
        try {
            if (FI_STAX_WRITER_CLASS == null) {
                return null;
            }
            ClassLoader classLoader = ClassLoaderRetriever.getClassLoader();
            Class<?> clazz = Class.forName("com.sun.xml.internal.bind.v2.runtime.output.FastInfosetStreamWriterOutput", true, classLoader);
            return clazz.getConstructor(FI_STAX_WRITER_CLASS, JAXBContextImpl.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Class initStAXExWriterClass() {
        try {
            ClassLoader classLoader = ClassLoaderRetriever.getClassLoader();
            return Class.forName("com.sun.xml.internal.org.jvnet.staxex.XMLStreamWriterEx", true, classLoader);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Constructor<? extends XmlOutput> initStAXExOutputClass() {
        try {
            ClassLoader classLoader = ClassLoaderRetriever.getClassLoader();
            Class<?> clazz = Class.forName("com.sun.xml.internal.bind.v2.runtime.output.StAXExStreamWriterOutput", true, classLoader);
            return clazz.getConstructor(STAXEX_WRITER_CLASS);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

