/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.sg.PGImageView;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import com.sun.prism.image.CachingCompoundImage;
import com.sun.prism.image.CompoundCoords;
import com.sun.prism.image.Coords;
import com.sun.prism.image.ViewPort;

public class NGImageView
extends NGNode
implements PGImageView {
    private Image image;
    private CachingCompoundImage compoundImage;
    private CompoundCoords compoundCoords;
    private float x;
    private float y;
    private float w;
    private float h;
    private Coords coords;
    private ViewPort viewport;
    private boolean renderable = false;
    private boolean coordsOK = false;
    static final int MAX_SIZE_OVERRIDE = 0;

    private void invalidate() {
        this.coordsOK = false;
        this.coords = null;
        this.compoundCoords = null;
        this.geometryChanged();
    }

    @Override
    public void setViewport(float f, float f2, float f3, float f4, float f5, float f6, boolean bl) {
        float f7;
        float f8 = this.image != null ? (float)this.image.getWidth() : 0.0f;
        float f9 = f7 = this.image != null ? (float)this.image.getHeight() : 0.0f;
        if (f5 > 0.0f && f6 > 0.0f) {
            this.viewport = new ViewPort(f3, f4, f5, f6);
            f8 = f5;
            f7 = f6;
        } else {
            this.viewport = null;
        }
        if (bl && (f > 0.0f || f2 > 0.0f)) {
            if (f <= 0.0f || f2 > 0.0f && f * f7 > f2 * f8) {
                this.w = f8 * f2 / f7;
                this.h = f2;
            } else {
                this.w = f;
                this.h = f7 * f / f8;
            }
        } else {
            this.w = f > 0.0f ? f : f8;
            this.h = f2 > 0.0f ? f2 : f7;
        }
        this.invalidate();
    }

    private void calculatePositionAndClipping() {
        this.renderable = false;
        this.coordsOK = true;
        if (this.viewport == null) {
            this.renderable = this.image != null;
            return;
        }
        float f = this.image.getWidth();
        float f2 = this.image.getHeight();
        if (f == 0.0f || f2 == 0.0f) {
            return;
        }
        this.coords = this.viewport.getClippedCoords(f, f2, this.w, this.h);
        this.renderable = this.coords != null;
    }

    @Override
    protected void doRender(Graphics graphics) {
        if (!this.coordsOK) {
            this.calculatePositionAndClipping();
        }
        if (this.renderable) {
            super.doRender(graphics);
        }
    }

    private int maxSizeWrapper(ResourceFactory resourceFactory) {
        return resourceFactory.getMaximumTextureSize();
    }

    @Override
    protected void renderContent(Graphics graphics) {
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        ResourceFactory resourceFactory = graphics.getResourceFactory();
        int n3 = this.maxSizeWrapper(resourceFactory);
        if (n <= n3 && n2 <= n3) {
            Texture texture = resourceFactory.getCachedTexture(this.image, false);
            if (this.coords == null) {
                graphics.drawTexture(texture, this.x, this.y, this.x + this.w, this.y + this.h, 0.0f, 0.0f, n, n2, 0);
            } else {
                this.coords.draw(texture, graphics, this.x, this.y);
            }
        } else {
            if (this.compoundImage == null) {
                this.compoundImage = new CachingCompoundImage(this.image, n3);
            }
            if (this.coords == null) {
                this.coords = new Coords(this.w, this.h, new ViewPort(0.0f, 0.0f, n, n2));
            }
            if (this.compoundCoords == null) {
                this.compoundCoords = new CompoundCoords(this.compoundImage, this.coords);
            }
            this.compoundCoords.draw(graphics, this.compoundImage, this.x, this.y);
        }
    }

    @Override
    protected boolean hasOverlappingContents() {
        return false;
    }

    @Override
    public void setImage(Object object) {
        Image image = (Image)object;
        if (this.image == image) {
            return;
        }
        boolean bl = image == null || this.image == null || this.image.getHeight() != image.getHeight() || this.image.getWidth() != image.getWidth();
        this.image = image;
        this.compoundImage = null;
        if (bl) {
            this.invalidate();
        }
    }

    @Override
    public void setX(float f) {
        if (this.x != f) {
            this.x = f;
            this.geometryChanged();
        }
    }

    @Override
    public void setY(float f) {
        if (this.y != f) {
            this.y = f;
            this.geometryChanged();
        }
    }

    @Override
    public void setSmooth(boolean bl) {
    }
}

