/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.es2.gl;

import com.sun.javafx.PlatformUtil;
import com.sun.prism.es2.gl.GLContext;
import com.sun.prism.es2.gl.GLDrawable;
import com.sun.prism.es2.gl.GLGPUInfo;
import com.sun.prism.es2.gl.GLPixelFormat;
import com.sun.prism.impl.PrismSettings;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;

public abstract class GLFactory {
    private static final GLFactory platformFactory;
    protected long nativeCtxInfo;
    protected boolean gl2 = false;
    private GLContext shareCtx = null;

    private static native boolean nIsGLExtensionSupported(long var0, String var2);

    private static native String nGetGLVendor(long var0);

    private static native String nGetGLRenderer(long var0);

    private static native String nGetGLVersion(long var0);

    protected GLFactory() {
    }

    public static GLFactory getFactory() throws RuntimeException {
        if (null != platformFactory) {
            return platformFactory;
        }
        throw new RuntimeException("No native platform GLFactory available.");
    }

    protected abstract GLGPUInfo[] getPreQualificationFilter();

    protected abstract GLGPUInfo[] getBlackList();

    private static GLGPUInfo readGPUInfo(long l) {
        String string = GLFactory.nGetGLVendor(l);
        String string2 = GLFactory.nGetGLRenderer(l);
        return new GLGPUInfo(string.toLowerCase(), string2.toLowerCase());
    }

    private static boolean matches(GLGPUInfo gLGPUInfo, GLGPUInfo[] gLGPUInfoArray) {
        if (gLGPUInfoArray != null) {
            for (int i = 0; i < gLGPUInfoArray.length; ++i) {
                if (!gLGPUInfo.matches(gLGPUInfoArray[i])) continue;
                return true;
            }
        }
        return false;
    }

    private boolean inPreQualificationFilter(GLGPUInfo gLGPUInfo) {
        GLGPUInfo[] gLGPUInfoArray = this.getPreQualificationFilter();
        if (gLGPUInfoArray == null) {
            return true;
        }
        return GLFactory.matches(gLGPUInfo, gLGPUInfoArray);
    }

    private boolean inBlackList(GLGPUInfo gLGPUInfo) {
        return GLFactory.matches(gLGPUInfo, this.getBlackList());
    }

    public boolean isQualified(long l) {
        GLGPUInfo gLGPUInfo = GLFactory.readGPUInfo(l);
        if (gLGPUInfo.vendor == null || gLGPUInfo.model == null || gLGPUInfo.vendor.contains("unknown") || gLGPUInfo.model.contains("unknown")) {
            return false;
        }
        return this.inPreQualificationFilter(gLGPUInfo) && !this.inBlackList(gLGPUInfo);
    }

    public abstract GLContext createGLContext(long var1);

    public abstract GLContext createGLContext(GLDrawable var1, GLPixelFormat var2, GLContext var3, boolean var4);

    public abstract GLDrawable createGLDrawable(long var1, GLPixelFormat var3);

    public abstract GLDrawable createDummyGLDrawable(GLPixelFormat var1);

    public abstract GLPixelFormat createGLPixelFormat(long var1, GLPixelFormat.Attributes var3);

    public boolean isGLGPUQualify() {
        return this.isQualified(this.nativeCtxInfo);
    }

    public abstract boolean initialize(Class var1, GLPixelFormat.Attributes var2);

    public GLContext getShareContext() {
        if (this.shareCtx == null) {
            this.shareCtx = this.createGLContext(this.nativeCtxInfo);
        }
        return this.shareCtx;
    }

    public boolean isGL2() {
        return this.gl2;
    }

    public boolean isGLExtensionSupported(String string) {
        return GLFactory.nIsGLExtensionSupported(this.nativeCtxInfo, string);
    }

    public abstract int getAdapterCount();

    public abstract int getAdapterOrdinal(long var1);

    public abstract void updateDeviceDetails(HashMap var1);

    public void updateDeviceDetails(HashMap hashMap, GLContext gLContext) {
    }

    public void printDriverInformation(int n) {
        System.out.println("Graphics Vendor: " + GLFactory.nGetGLVendor(this.nativeCtxInfo));
        System.out.println("       Renderer: " + GLFactory.nGetGLRenderer(this.nativeCtxInfo));
        System.out.println("        Version: " + GLFactory.nGetGLVersion(this.nativeCtxInfo));
    }

    static {
        String string;
        if (PlatformUtil.isUnix()) {
            string = "eglx11".equals(PlatformUtil.getEmbeddedType()) ? "com.sun.prism.es2.gl.eglx11.EGLX11GLFactory" : ("eglfb".equals(PlatformUtil.getEmbeddedType()) ? "com.sun.prism.es2.gl.eglfb.EGLFBGLFactory" : "com.sun.prism.es2.gl.x11.X11GLFactory");
        } else if (PlatformUtil.isWindows()) {
            string = "com.sun.prism.es2.gl.win.WinGLFactory";
        } else if (PlatformUtil.isMac()) {
            string = "com.sun.prism.es2.gl.mac.MacGLFactory";
        } else {
            string = null;
            System.err.println("GLFactory.static - No Platform Factory for: " + System.getProperty("os.name"));
        }
        if (PrismSettings.verbose) {
            System.out.println("GLFactory using " + string);
        }
        platformFactory = AccessController.doPrivileged(new PrivilegedAction<GLFactory>(){

            @Override
            public GLFactory run() {
                GLFactory gLFactory = null;
                try {
                    if (null != string) {
                        gLFactory = (GLFactory)Class.forName(string).newInstance();
                    }
                }
                catch (Throwable throwable) {
                    System.err.println("GLFactory.static - Platform: " + System.getProperty("os.name") + " - not available: " + string);
                    throwable.printStackTrace();
                }
                return gLFactory;
            }
        });
    }
}

