/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc.keyinfo;

import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPublicKey;
import iaik.security.dh.ESDHPublicKeySpec;
import iaik.utils.Util;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.keyinfo.KeyValueType;
import iaik.xml.crypto.utils.DOMUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.interfaces.DHPublicKey;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DHKeyValueImpl
extends KeyValueType {
    protected int pGenCounter_ = 0;
    protected byte[] seed_ = null;
    protected BigInteger generator_ = null;
    protected BigInteger publicValue_ = null;
    protected BigInteger primeQ_ = null;
    protected BigInteger primeP_ = null;

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Node node;
        if (nodeList == null) {
            return;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            node = nodeList.item(n);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) {
                if (node.getLocalName().equals("P")) {
                    this.primeP_ = new BigInteger(1, DOMStructure.getBytesFromElement((Element)node));
                } else if (node.getLocalName().equals("Q")) {
                    this.primeQ_ = new BigInteger(1, DOMStructure.getBytesFromElement((Element)node));
                } else if (node.getLocalName().equals("Public")) {
                    this.publicValue_ = new BigInteger(1, DOMStructure.getBytesFromElement((Element)node));
                } else if (node.getLocalName().equals("Generator")) {
                    this.generator_ = new BigInteger(1, DOMStructure.getBytesFromElement((Element)node));
                } else if (node.getLocalName().equals("seed")) {
                    this.seed_ = DOMStructure.getBytesFromElement((Element)node);
                } else if (node.getLocalName().equals("Public")) {
                    this.pGenCounter_ = new BigInteger(1, DOMStructure.getBytesFromElement((Element)node)).intValue();
                }
            }
            ++n;
        }
        node = new ESDHPublicKeySpec(this.publicValue_, this.primeP_, this.primeQ_, this.generator_, this.seed_, this.pGenCounter_);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("ESDH", "IAIK");
            this.publicKey_ = (ESDHPublicKey)keyFactory.generatePublic((KeySpec)((Object)node));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException("Failed to create DH Public key");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new MarshalException("Failed to create DH Public key");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new MarshalException("Failed to create DH Public key");
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element;
        Element element2;
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2001/04/xmlenc#", dOMCryptoContext.getDefaultNamespacePrefix());
        if (!(this.publicKey_ instanceof ESDHPublicKey)) {
            throw new MarshalException("PublicKey must be of instance \"iaik.security.dh.DHPublicKey\"");
        }
        ESDHPublicKey eSDHPublicKey = (ESDHPublicKey)this.publicKey_;
        ESDHParameterSpec eSDHParameterSpec = (ESDHParameterSpec)eSDHPublicKey.getParams();
        BigInteger bigInteger = eSDHParameterSpec.getP();
        BigInteger bigInteger2 = eSDHParameterSpec.getQ();
        BigInteger bigInteger3 = eSDHParameterSpec.getG();
        BigInteger bigInteger4 = eSDHPublicKey.getY();
        byte[] byArray = eSDHParameterSpec.getSeed();
        Integer n = new Integer(eSDHParameterSpec.getPGenCounter());
        byte[] byArray2 = Util.toByteArray((String)n.toString());
        if (bigInteger != null) {
            element2 = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DOMStructure.getQualifiedName(string, "P"));
            DOMStructure.addBytesToElement(element2, DOMUtils.bigInteger2byteArray(bigInteger), dOMCryptoContext);
            node3.appendChild(element2);
        }
        if (bigInteger2 != null) {
            element2 = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DOMStructure.getQualifiedName(string, "Q"));
            DOMStructure.addBytesToElement(element2, DOMUtils.bigInteger2byteArray(bigInteger2), dOMCryptoContext);
            node3.appendChild(element2);
        }
        if (bigInteger3 != null) {
            element2 = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DOMStructure.getQualifiedName(string, "Generator"));
            DOMStructure.addBytesToElement(element2, DOMUtils.bigInteger2byteArray(bigInteger3), dOMCryptoContext);
            node3.appendChild(element2);
        }
        if (bigInteger4 == null) {
            throw new MarshalException("Value \"Public\" must not be null");
        }
        element2 = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DOMStructure.getQualifiedName(string, "Public"));
        DOMStructure.addBytesToElement(element2, DOMUtils.bigInteger2byteArray(bigInteger4), dOMCryptoContext);
        node3.appendChild(element2);
        if (byArray != null) {
            element = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DOMStructure.getQualifiedName(string, "seed"));
            DOMStructure.addBytesToElement(element, byArray, dOMCryptoContext);
            node3.appendChild(element);
        }
        if (n != null) {
            element = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DOMStructure.getQualifiedName(string, "pgenCounter"));
            DOMStructure.addBytesToElement(element, byArray2, dOMCryptoContext);
            node3.appendChild(element);
        }
        return node3;
    }

    public byte[] getSeed() {
        return this.seed_;
    }

    public BigInteger getPublicValue() {
        return this.publicValue_;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ_;
    }

    public BigInteger getPrimeP() {
        return this.primeP_;
    }

    public int getPGenCounter() {
        return this.pGenCounter_;
    }

    public String getLocalName() {
        return "DHKeyValue";
    }

    public BigInteger getGenerator() {
        return this.generator_;
    }

    public DHKeyValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
    }

    public DHKeyValueImpl(DHPublicKey dHPublicKey) {
        super(dHPublicKey);
    }
}

