/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.asn1.structures.Name;
import iaik.utils.RFC2253NameParser;
import iaik.utils.RFC2253NameParserException;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.xades.CRLIdentifier;
import iaik.xml.crypto.xades.dom.XadesDOMStructure;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.Date;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CRLIdentifierImpl
extends XadesDOMStructure
implements DOMURIReference,
CRLIdentifier {
    private String a;
    private BigInteger b;
    private Date d;
    private Name c;

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        if (nodeList == null) {
            return;
        }
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && node.getNamespaceURI().equals("http://uri.etsi.org/01903/v1.3.2#")) {
                if (node.getLocalName().equals("Issuer")) {
                    String string = DOMUtils.getAllTextFromChildren((Element)((Element)node));
                    try {
                        this.c = new RFC2253NameParser(string).parse();
                    }
                    catch (RFC2253NameParserException rFC2253NameParserException) {
                        throw new MarshalException("X509IssuerName '" + string + "' is not RFC 2253 complaint.");
                    }
                } else if (node.getLocalName().equals("IssueTime")) {
                    try {
                        this.d = DOMUtils.getDateTimeFromElementChildren((Element)((Element)node));
                    }
                    catch (ParseException parseException) {
                        throw new MarshalException("Failed to parse IssueTime. " + parseException.getMessage(), parseException);
                    }
                } else if (node.getLocalName().equals("Number")) {
                    this.b = DOMUtils.getBigIntegerFromElementChildrens((Element)((Element)node));
                }
            }
            ++n;
        }
    }

    protected void unmarshalAttributes(NamedNodeMap namedNodeMap, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Attr attr = (Attr)namedNodeMap.getNamedItemNS(null, "URI");
        this.a = attr != null ? attr.getValue() : null;
        super.unmarshalAttributes(namedNodeMap, dOMCryptoContext);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("    Issuer : '" + this.c + "'\n");
        stringBuffer.append("    Number : " + this.b + "\n");
        stringBuffer.append("    IssuerTime : " + this.d + "\n");
        stringBuffer.append("    URI : " + this.a + "\n");
        return stringBuffer.toString();
    }

    protected void marshalAttributes(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.marshalAttributes(dOMCryptoContext, element);
        if (this.a != null) {
            Document document = DOMUtils.getOwnerDocument((Node)element);
            Attr attr = document.createAttributeNS("", "URI");
            attr.setValue(this.a);
            element.setAttributeNodeNS(attr);
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Document document = DOMUtils.getOwnerDocument((Node)node);
        String string = dOMCryptoContext.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", dOMCryptoContext.getDefaultNamespacePrefix());
        Element element = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", DOMStructure.getQualifiedName((String)string, (String)"Issuer"));
        Element element2 = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", DOMStructure.getQualifiedName((String)string, (String)"IssueTime"));
        try {
            DOMUtils.addTextToElement((Element)element, (String)this.c.getRFC2253String());
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            throw new MarshalException("Failed to convert issuer DN into an RFC 2253 complaint string. " + rFC2253NameParserException.getMessage(), rFC2253NameParserException);
        }
        DOMUtils.addDateTimeToElement((Element)element2, (Date)this.d);
        node3.appendChild(element);
        node3.appendChild(element2);
        if (this.b != null) {
            Element element3 = document.createElementNS("http://uri.etsi.org/01903/v1.3.2#", DOMStructure.getQualifiedName((String)string, (String)"Number"));
            DOMUtils.addBigIntegerToElement((Element)element3, (BigInteger)this.b);
            node3.appendChild(element3);
        }
        return node3;
    }

    public String getURI() {
        return this.a;
    }

    public String getType() {
        return null;
    }

    public BigInteger getNumber() {
        return this.b;
    }

    public String getLocalName() {
        return "CRLIdentifier";
    }

    public Date getIssuerTime() {
        return this.d;
    }

    public String getIssuer() {
        try {
            return this.c.getRFC2253String();
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            throw new RuntimeException(rFC2253NameParserException.getMessage());
        }
    }

    public Node getHere() {
        return super.getHere();
    }

    public CRLIdentifierImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.c == null || this.d == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public CRLIdentifierImpl(String string, Date date, BigInteger bigInteger, String string2) {
        if (string == null) {
            throw new NullPointerException("Argument 'issuer' must not be null");
        }
        RFC2253NameParser rFC2253NameParser = new RFC2253NameParser(string);
        try {
            this.c = rFC2253NameParser.parse();
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            throw new IllegalArgumentException("Issuer '" + string + "' is not RFC 2253 complaint. " + rFC2253NameParserException.getMessage());
        }
        if (date == null) {
            throw new NullPointerException("Argument 'isserTime' must not be null");
        }
        this.d = date;
        this.b = bigInteger;
        this.a = string2;
    }
}

