/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.xml.crypto.xades.EncapsulatedCRLValue;
import iaik.xml.crypto.xades.impl.dom.properties.EncapsulatedPKIDataType;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Node;

public class EncapsulatedCRLValueImpl
extends EncapsulatedPKIDataType
implements EncapsulatedCRLValue {
    private X509CRL a;

    protected void setEncodedPKIValue(InputStream inputStream, String string) throws MarshalException {
        if (string == null || string.equals("http://uri.etsi.org/01903/v1.2.2#DER") || string.equals("http://uri.etsi.org/01903/v1.2.2#BER")) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                this.a = (X509CRL)certificateFactory.generateCRL(inputStream);
            }
            catch (CertificateException certificateException) {
                throw new MarshalException("Failed to decode CRL, " + certificateException.getMessage(), certificateException);
            }
            catch (CRLException cRLException) {
                throw new MarshalException("Failed to decode CRL, " + cRLException.getMessage(), cRLException);
            }
        } else {
            throw new MarshalException("Failed to decode CRL, encoding mechanism '" + string + "' is not supported");
        }
    }

    public String getLocalName() {
        return "EncapsulatedCRLValue";
    }

    protected InputStream getEncodedPKIValue(String string) throws MarshalException {
        if (string == null || string.equals("http://uri.etsi.org/01903/v1.2.2#DER")) {
            try {
                return new ByteArrayInputStream(this.a.getEncoded());
            }
            catch (CRLException cRLException) {
                throw new MarshalException("Failed to encode CRL, " + cRLException.getMessage(), cRLException);
            }
        }
        throw new MarshalException("Failed to encode CRL, encoding mechanism '" + string + "' is not supported");
    }

    public X509CRL getCRL() {
        return this.a;
    }

    public EncapsulatedCRLValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.a == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public EncapsulatedCRLValueImpl(X509CRL x509CRL, String string, String string2) {
        super(string, string2);
        if (x509CRL == null) {
            throw new NullPointerException("Argument 'crl' must not be null.");
        }
        this.a = x509CRL;
    }
}

