/*
 * Decompiled with CFR 0.152.
 */
package demo.cms;

import demo.DemoUtil;
import iaik.asn1.ASN1Object;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.CMSException;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs7.DigestedData;
import iaik.pkcs.pkcs7.DigestedDataStream;
import iaik.security.random.SecRandom;
import iaik.utils.StreamCopier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class PKCS7CMSDigestedData {
    SecureRandom random;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nImplicit DigestedDataStream demo [create]:\n");
            byte[] byArray3 = this.createDigestedDataStream(byArray, 1);
            System.out.println("\nImplicit DigestedDataStream demo [parse]:\n");
            byArray2 = this.getDigestedDataStream(byArray3, null);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit DigestedDataStream demo [create]:\n");
            byArray3 = this.createDigestedDataStream(byArray, 2);
            System.out.println("\nExplicit DigestedDataStream demo [parse]:\n");
            byArray2 = this.getDigestedDataStream(byArray3, byArray);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("Testing compatiblity to PKCS#7...");
            System.out.println("\nCMS Implicit DigestedDataStream demo [create]:\n");
            byArray3 = this.createDigestedDataStream(byArray, 1);
            System.out.println("\nPKCS#7 Implicit DigestedDataStream demo [parse]:\n");
            byArray2 = this.getPKCS7DigestedDataStream(byArray3, null);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nPKCS#7 Implicit DigestedDataStream demo [create]:\n");
            byArray3 = this.createPKCS7DigestedDataStream(byArray, 1);
            System.out.println("\nCMS Implicit DigestedDataStream demo [parse]:\n");
            byArray2 = this.getDigestedDataStream(byArray3, null);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCMS Explicit DigestedDataStream demo [create]:\n");
            byArray3 = this.createDigestedDataStream(byArray, 2);
            System.out.println("\nPKCS#7 Explicit DigestedDataStream demo [parse]:\n");
            byArray2 = this.getPKCS7DigestedDataStream(byArray3, byArray);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nPKCS#7 Explicit DigestedDataStream demo [create]:\n");
            byArray3 = this.createPKCS7DigestedDataStream(byArray, 2);
            System.out.println("\nCMS Explicit DigestedDataStream demo [parse]:\n");
            byArray2 = this.getDigestedDataStream(byArray3, byArray);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            ASN1Object aSN1Object = null;
            System.out.println("\nImplicit DigestedData demo [create]:\n");
            aSN1Object = this.createDigestedData(byArray, 1);
            System.out.println("\nImplicit DigestedData demo [parse]:\n");
            byArray2 = this.getDigestedData(aSN1Object, null);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit DigestedData demo [create]:\n");
            aSN1Object = this.createDigestedData(byArray, 2);
            System.out.println("\nExplicit DigestedData demo [parse]:\n");
            byArray2 = this.getDigestedData(aSN1Object, byArray);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("Testing compatibility to PKCS#7...");
            System.out.println("\nCMS Implicit DigestedData demo [create]:\n");
            aSN1Object = this.createDigestedData(byArray, 1);
            System.out.println("\nPKCS#7 Implicit DigestedData demo [parse]:\n");
            byArray2 = this.getPKCS7DigestedData(aSN1Object, null);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nPKCS#7 Implicit DigestedData demo [create]:\n");
            aSN1Object = this.createPKCS7DigestedData(byArray, 1);
            System.out.println("\nCMS Implicit DigestedData demo [parse]:\n");
            byArray2 = this.getDigestedData(aSN1Object, null);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nCMS Explicit DigestedData demo [create]:\n");
            aSN1Object = this.createDigestedData(byArray, 2);
            System.out.println("\nPKCS#7 Explicit DigestedData demo [parse]:\n");
            byArray2 = this.getPKCS7DigestedData(aSN1Object, byArray);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            System.out.println("\nPKCS7 Explicit DigestedData demo [create]:\n");
            aSN1Object = this.createPKCS7DigestedData(byArray, 2);
            System.out.println("\nCMS Explicit DigestedData demo [parse]:\n");
            byArray2 = this.getDigestedData(aSN1Object, byArray);
            System.out.print("\nContent: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new PKCS7CMSDigestedData().start();
        System.in.read();
    }

    public byte[] getPKCS7DigestedDataStream(byte[] byArray, byte[] byArray2) throws IOException, PKCSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DigestedDataStream digestedDataStream = null;
        digestedDataStream = byArray2 == null ? new DigestedDataStream((InputStream)byteArrayInputStream) : new DigestedDataStream((InputStream)new ByteArrayInputStream(byArray2), AlgorithmID.md5);
        InputStream inputStream = digestedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray2 != null) {
            digestedDataStream.decode((InputStream)byteArrayInputStream);
        }
        if (digestedDataStream.verify()) {
            System.out.println("Hash ok!");
        } else {
            System.out.println("Hash verification failed!");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getPKCS7DigestedData(ASN1Object aSN1Object, byte[] byArray) throws IOException, PKCSException {
        DigestedData digestedData = null;
        if (byArray == null) {
            digestedData = new DigestedData(aSN1Object);
        } else {
            try {
                digestedData = new DigestedData(byArray, AlgorithmID.sha);
                digestedData.decode(aSN1Object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PKCSException(noSuchAlgorithmException.toString());
            }
        }
        if (digestedData.verify()) {
            System.out.println("Hash ok!");
        } else {
            System.out.println("Hash verification failed!");
        }
        return digestedData.getContent();
    }

    public byte[] getDigestedDataStream(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        iaik.cms.DigestedDataStream digestedDataStream = null;
        digestedDataStream = byArray2 == null ? new iaik.cms.DigestedDataStream((InputStream)byteArrayInputStream) : new iaik.cms.DigestedDataStream((InputStream)new ByteArrayInputStream(byArray2), AlgorithmID.md5);
        InputStream inputStream = digestedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        if (byArray2 != null) {
            digestedDataStream.decode((InputStream)byteArrayInputStream);
        }
        if (digestedDataStream.verify()) {
            System.out.println("Hash ok!");
        } else {
            System.out.println("Hash verification failed!");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getDigestedData(ASN1Object aSN1Object, byte[] byArray) throws IOException, CMSException {
        iaik.cms.DigestedData digestedData = null;
        if (byArray == null) {
            digestedData = new iaik.cms.DigestedData(aSN1Object);
        } else {
            try {
                digestedData = new iaik.cms.DigestedData(byArray, AlgorithmID.sha);
                digestedData.decode(aSN1Object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new CMSException(noSuchAlgorithmException.toString());
            }
        }
        if (digestedData.verify()) {
            System.out.println("Hash ok!");
        } else {
            System.out.println("Hash verification failed!");
        }
        return digestedData.getContent();
    }

    public byte[] createPKCS7DigestedDataStream(byte[] byArray, int n) throws IOException, PKCSException {
        Closeable closeable;
        System.out.println("Create a new message to be digested:");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DigestedDataStream digestedDataStream = null;
        digestedDataStream = new DigestedDataStream((InputStream)byteArrayInputStream, AlgorithmID.md5, n);
        if (n == 2) {
            int n2;
            closeable = digestedDataStream.getInputStream();
            byte[] byArray2 = new byte[1024];
            while ((n2 = ((InputStream)closeable).read(byArray2)) > 0) {
            }
        }
        closeable = new ByteArrayOutputStream();
        digestedDataStream.writeTo((OutputStream)closeable, 2048);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public ASN1Object createPKCS7DigestedData(byte[] byArray, int n) throws IOException, PKCSException {
        System.out.println("Create a new digested message:");
        DigestedData digestedData = new DigestedData(byArray, AlgorithmID.sha, n);
        return digestedData.toASN1Object();
    }

    public byte[] createDigestedDataStream(byte[] byArray, int n) throws IOException, CMSException {
        Closeable closeable;
        System.out.println("Create a new message to be digested:");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        iaik.cms.DigestedDataStream digestedDataStream = null;
        digestedDataStream = new iaik.cms.DigestedDataStream((InputStream)byteArrayInputStream, AlgorithmID.md5, n);
        if (n == 2) {
            int n2;
            closeable = digestedDataStream.getInputStream();
            byte[] byArray2 = new byte[1024];
            while ((n2 = ((InputStream)closeable).read(byArray2)) > 0) {
            }
        }
        closeable = new ByteArrayOutputStream();
        digestedDataStream.writeTo((OutputStream)closeable, 2048);
        return ((ByteArrayOutputStream)closeable).toByteArray();
    }

    public ASN1Object createDigestedData(byte[] byArray, int n) throws IOException, CMSException {
        System.out.println("Create a new digested message:");
        iaik.cms.DigestedData digestedData = new iaik.cms.DigestedData(byArray, AlgorithmID.sha, n);
        return digestedData.toASN1Object();
    }

    public PKCS7CMSDigestedData() throws IOException {
        System.out.println();
        System.out.println("***********************************************************************************************");
        System.out.println("*                                 PKCS7CMSDigestedData demo                                   *");
        System.out.println("* (tests the CMS DigestedData against the IAIK-JCE PKCS#7 DigestedData type implementation)   *");
        System.out.println("***********************************************************************************************");
        System.out.println();
        this.random = SecRandom.getDefault();
    }
}

