/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.ecc.ecdsa;

import iaik.security.ecc.ecdsa.ECPrivateKey;
import iaik.security.ecc.ecdsa.ECPublicKey;
import iaik.security.ecc.math.ecgroup.ECPoint;
import iaik.security.ecc.math.field.Constants;
import iaik.security.ecc.util.SignatureFormater;
import iaik.security.ecc.util.Transforms;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;

public class RawECDSA
extends Signature {
    protected SecureRandom secureRandom_;
    protected ECPublicKey publicKey_;
    protected ECPrivateKey privateKey_;
    private int hashIndex_;
    private byte[] hashBytes_ = new byte[20];

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        Object object;
        try {
            object = new SignatureFormater(byArray);
            bigInteger2 = ((SignatureFormater)object).getR();
            bigInteger = ((SignatureFormater)object).getS();
        }
        catch (Exception exception) {
            throw new SignatureException("Invalid signature format");
        }
        object = this.publicKey_.getParameter().getR();
        int n = bigInteger2.compareTo(Constants.BIG_ONE);
        int n2 = bigInteger2.compareTo(((BigInteger)object).subtract(Constants.BIG_ONE));
        if (n == -1 || n2 == 1) {
            return false;
        }
        n = bigInteger.compareTo(Constants.BIG_ZERO);
        n2 = bigInteger.compareTo(((BigInteger)object).subtract(Constants.BIG_ONE));
        if (n == -1 || n2 == 1) {
            return false;
        }
        BigInteger bigInteger3 = new BigInteger(1, this.hashBytes_);
        BigInteger bigInteger4 = bigInteger.modInverse((BigInteger)object);
        BigInteger bigInteger5 = bigInteger3.multiply(bigInteger4).mod((BigInteger)object);
        BigInteger bigInteger6 = bigInteger2.multiply(bigInteger4).mod((BigInteger)object);
        ECPoint eCPoint = this.publicKey_.getParameter().getG();
        ECPoint eCPoint2 = this.publicKey_.getW();
        eCPoint.multiply2(bigInteger5, eCPoint2, bigInteger6);
        if (eCPoint.isInfinity()) {
            return false;
        }
        BigInteger bigInteger7 = Transforms.xToBigInteger(eCPoint);
        return bigInteger7.mod((BigInteger)object).equals(bigInteger2);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            int n3 = n;
            while (n3 < n2) {
                this.hashBytes_[this.hashIndex_++] = byArray[n3];
                ++n3;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        try {
            this.hashBytes_[this.hashIndex_++] = by;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
    }

    protected byte[] engineSign() throws SignatureException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        if (this.hashIndex_ != 20) {
            throw new SignatureException("Data has to be exactly 20 Bytes in total!");
        }
        this.hashIndex_ = 0;
        if (this.privateKey_ == null) {
            throw new SignatureException("No private key set");
        }
        if (this.secureRandom_ == null) {
            this.secureRandom_ = SecRandom.getDefault();
        }
        BigInteger bigInteger4 = new BigInteger(1, this.hashBytes_);
        BigInteger bigInteger5 = this.privateKey_.getParameter().getR();
        BigInteger bigInteger6 = bigInteger5.subtract(Constants.BIG_ONE);
        do {
            bigInteger = new BigInteger(bigInteger5.bitLength(), this.secureRandom_);
            int n = bigInteger.compareTo(Constants.BIG_ONE);
            int n2 = bigInteger.compareTo(bigInteger6);
            while (n == -1 || n2 == 1) {
                bigInteger = new BigInteger(bigInteger5.bitLength(), this.secureRandom_);
                n = bigInteger.compareTo(Constants.BIG_ONE);
                n2 = bigInteger.compareTo(bigInteger6);
            }
            ECPoint eCPoint = (ECPoint)this.privateKey_.getParameter().getG().clone();
            eCPoint.multiply(bigInteger);
            bigInteger2 = Transforms.xToBigInteger(eCPoint);
        } while ((bigInteger3 = !(bigInteger2 = bigInteger2.mod(bigInteger5)).equals(Constants.BIG_ZERO) ? bigInteger.modInverse(bigInteger5).multiply(bigInteger4.add(this.privateKey_.getS().multiply(bigInteger2))).mod(bigInteger5) : Constants.BIG_ZERO).equals(Constants.BIG_ZERO) || bigInteger2.equals(Constants.BIG_ZERO));
        byte[] byArray = SignatureFormater.getSignature(bigInteger2, bigInteger3);
        bigInteger = null;
        return byArray;
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException("Not Implemented");
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("Wrong key type (an instance of ECPublicKey required!)");
        }
        this.publicKey_ = (ECPublicKey)publicKey;
        this.publicKey_.validatePublicKey();
        this.hashIndex_ = 0;
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Wrong key type (an instance of ECPrivateKey required!)");
        }
        this.privateKey_ = (ECPrivateKey)privateKey;
        this.hashIndex_ = 0;
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException("Not Implemented");
    }

    public RawECDSA() {
        super("RawECDSA");
    }
}

