/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.campi;

import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.risorse.ModelloSet;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class ProvinciaModel
extends GericoModel {
    private String valorePredefinito = "";
    private static Hashtable ht_CT = new Hashtable();
    private static boolean info = false;

    public ProvinciaModel(String code, String errorDescription, int length) throws IllegalArgumentException {
        super(code, errorDescription, length);
        ProvinciaModel.caricaInfo();
        this.setValorePredefinito();
    }

    private static void caricaInfo() throws IllegalArgumentException {
        if (!info) {
            try {
                ModelloSet mSet = new ModelloSet("");
                Vector v = mSet.getInformazioniModel("province.ger");
                int j = 0;
                int size = v.size();
                while (j < size) {
                    String provincia = (String)v.elementAt(j);
                    ht_CT.put(provincia, "valida");
                    ++j;
                }
                info = true;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("ModelloSet.getInformazioniModel(province.ger)");
            }
        }
    }

    public String getValorePredefinito() {
        return this.valorePredefinito;
    }

    public boolean isValorePredefinito() {
        return this.getValue().equals(this.valorePredefinito);
    }

    public void setValore(String s) throws ControlloFormaleException {
        try {
            if (s.trim().equals(this.valorePredefinito)) {
                this.setValorePredefinito();
            } else {
                boolean found = false;
                if (ht_CT.get(s.toUpperCase()) != null) {
                    found = true;
                    this.valore = s.toUpperCase();
                }
                if (!found) {
                    if (s.length() > this.length()) {
                        this.errore = "020";
                        this.gravitaErrore = "scarto";
                        throw new ControlloFormaleException(s);
                    }
                    this.errore = "012";
                    this.gravitaErrore = "scarto_confermabile";
                    throw new ControlloFormaleException(s);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.errore = "012";
            this.gravitaErrore = "scarto_confermabile";
            throw new ControlloFormaleException(s);
        }
    }

    public void setValorePredefinito() {
        this.valore = this.valorePredefinito;
    }
}

