/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.risorse;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class LeggiRisorse {
    public static final String EXT = ".ger";
    private Hashtable hTipiBeans = null;
    private final String PATH_APPLICAZIONE = new File(" ").getAbsolutePath().trim();
    private final String SEPARATOR = System.getProperty("file.separator");
    private String FILE_TIPIBEANS = "beans.ger";
    private final String FILE_COD_ATTIVITA = "grcfile.ger";
    public static final String FILE_TABELLA_AS_M = "annosepam.ger";
    public static final String FILE_TABELLA_AS_N = "annosepan.ger";
    public static final String FILE_TABELLA_PAR = "parametri.ger";
    public static final String FILE_TESTA_STUDI = "testa.ger";
    public static final String FILE_TESTA_AS = "testaas.ger";
    public static final String FILE_TESTA_AS_M = "testam.ger";
    public static final String FILE_TESTA_AS_N = "testan.ger";
    public static final String FILE_TESTA_PARAMETRI = "testa_parametri.ger";
    public static final String JAR_FINANZE = "finanze.jar";
    public final String FILE_OUTPUT = "output.txt";

    private Hashtable getHTipiBeans() throws IOException {
        if (this.hTipiBeans == null) {
            this.hTipiBeans = this.leggiTipiBeans();
        }
        return this.hTipiBeans;
    }

    public Vector leggiCodiciStudio() throws IOException {
        try {
            InputStream is = this.getClass().getResourceAsStream("grcfile.ger");
            if (is == null) {
                throw new FileNotFoundException();
            }
            LineNumberReader random = new LineNumberReader(new InputStreamReader(is));
            Vector<String[]> vCodAttivita = new Vector<String[]>();
            String linea = random.readLine();
            StringTokenizer st = null;
            String codiceAtt = null;
            String codiceStudio = null;
            while (linea != null) {
                st = new StringTokenizer(linea, "*");
                codiceAtt = st.nextToken();
                st.nextToken();
                codiceStudio = st.nextToken();
                vCodAttivita.addElement(new String[]{codiceAtt, codiceStudio});
                linea = random.readLine();
            }
            random.close();
            random = null;
            linea = null;
            st = null;
            codiceAtt = null;
            codiceStudio = null;
            return vCodAttivita;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File grcfile.ger non trovato");
        }
        catch (IOException iOException) {
            throw new IOException("Errore nella lettura del file grcfile.ger");
        }
        catch (Exception exception) {
            throw new IOException("Errore nella lettura del file : file grcfile.ger errato ");
        }
    }

    public Vector leggiFile(String nomeFile) throws IOException {
        try {
            FileReader fr = new FileReader(nomeFile);
            BufferedReader br = new BufferedReader(fr);
            String linea = "";
            Vector<String> vecRecord = new Vector<String>();
            linea = br.readLine();
            while (linea != null) {
                if (linea.startsWith("Q") || linea.startsWith("R") || linea.startsWith("S") || linea.startsWith("T") || linea.startsWith("U")) {
                    vecRecord.addElement(linea);
                }
                linea = br.readLine();
            }
            br.close();
            fr.close();
            return vecRecord;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File " + nomeFile + "non trovato");
        }
        catch (IOException iOException) {
            throw new IOException("Errore nella lettura del file " + nomeFile);
        }
        catch (Exception exception) {
            throw new IOException("Errore nella lettura del file " + nomeFile);
        }
    }

    public StringBuffer leggiFileHelp(String nomeFile) throws IOException {
        try {
            LineNumberReader br = new LineNumberReader(new InputStreamReader(this.getClass().getResourceAsStream(nomeFile)));
            String linea = "";
            StringBuffer sb = new StringBuffer();
            linea = br.readLine();
            while (linea != null) {
                sb.append(String.valueOf(linea) + "\r\n");
                linea = br.readLine();
            }
            br.close();
            return sb;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File " + nomeFile + "non trovato");
        }
        catch (IOException iOException) {
            throw new IOException("Errore nella lettura del file " + nomeFile);
        }
        catch (Exception exception) {
            throw new IOException("Errore nella lettura del file " + nomeFile);
        }
    }

    public Vector leggiTabella(Vector specifichePos, String fileTabella, boolean isRecordR) throws IOException {
        try {
            InputStream is = this.getClass().getResourceAsStream(fileTabella.toLowerCase());
            if (is == null) {
                throw new FileNotFoundException();
            }
            LineNumberReader random = new LineNumberReader(new InputStreamReader(is));
            String linea = "";
            String tipo = "";
            String codice = "";
            String lunghezza = "";
            linea = random.readLine();
            linea = random.readLine();
            StringTokenizer st = null;
            while (!(linea.startsWith("[T*Personale") || linea.startsWith("[Y*Modello M") || linea.startsWith("[Z*Modello N") || linea.startsWith("[Q*Calcolo"))) {
                if (!(linea.startsWith("[") || linea.startsWith("-") || linea.startsWith("("))) {
                    st = new StringTokenizer(linea, "*");
                    tipo = st.nextToken();
                    codice = st.nextToken();
                    if (Integer.parseInt(this.getHTipiBeans().get(tipo).toString()) > 0) {
                        lunghezza = this.getHTipiBeans().get(tipo).toString();
                    } else {
                        st.nextToken();
                        lunghezza = st.nextToken();
                    }
                    if (linea.indexOf("#") != -1 || codice.compareTo("SCM1") == 0) {
                        codice = "#";
                        int pos = lunghezza.indexOf("#");
                        if (pos != -1) {
                            lunghezza = lunghezza.substring(0, pos);
                        }
                    }
                    specifichePos.addElement(new String[]{codice, lunghezza});
                } else {
                    if (linea.startsWith("-")) {
                        while (!linea.startsWith("[") && !linea.startsWith("(")) {
                            linea = random.readLine();
                        }
                    }
                    if (linea.startsWith("[pannelli]")) break;
                    if (linea.startsWith("[S*Dati Anagrafici*2]")) {
                        linea = random.readLine();
                        while (!linea.startsWith("[")) {
                            linea = random.readLine();
                        }
                    }
                }
                linea = random.readLine();
                st = null;
            }
            random.close();
            is.close();
            random = null;
            is = null;
            linea = null;
            tipo = null;
            codice = null;
            lunghezza = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File " + fileTabella + " non trovato");
        }
        catch (IOException iOException) {
            throw new IOException("Errore nella lettura del file " + fileTabella.toLowerCase());
        }
        catch (Exception exception) {
            throw new IOException("Errore nella lettura : il file " + fileTabella.toLowerCase() + " e'errato ");
        }
        return specifichePos;
    }

    public void leggiTesta(Vector specifichePos, String nomeFileTesta) throws IOException {
        try {
            InputStream is = this.getClass().getResourceAsStream(nomeFileTesta);
            if (is == null) {
                throw new FileNotFoundException();
            }
            LineNumberReader random = new LineNumberReader(new InputStreamReader(is));
            String linea = "";
            String tipo = "";
            String codice = "";
            String lunghezza = "";
            linea = random.readLine();
            StringTokenizer st = null;
            while (linea != null) {
                if (!linea.startsWith("[")) {
                    st = new StringTokenizer(linea, "*");
                    tipo = st.nextToken();
                    st.nextToken();
                    codice = st.nextToken();
                    lunghezza = Integer.parseInt(this.getHTipiBeans().get(tipo).toString()) > 0 ? this.getHTipiBeans().get(tipo).toString() : st.nextToken();
                    if (linea.indexOf("#") != -1 || codice.compareTo("SCM1") == 0) {
                        codice = "#";
                        int pos = lunghezza.indexOf("#");
                        if (pos != -1) {
                            lunghezza = lunghezza.substring(0, pos);
                        }
                    }
                    specifichePos.addElement(new String[]{codice, lunghezza});
                }
                linea = random.readLine();
                st = null;
            }
            random.close();
            is = null;
            linea = null;
            tipo = null;
            codice = null;
            st = null;
            lunghezza = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File " + nomeFileTesta + " non trovato");
        }
        catch (IOException iOException) {
            throw new IOException("Errore nella lettura del file " + nomeFileTesta);
        }
        catch (Exception exception) {
            throw new IOException("Errore nella lettura : il file " + nomeFileTesta + " e'errato ");
        }
    }

    private Hashtable leggiTipiBeans() throws IOException {
        try {
            Hashtable<String, String> hTipiBeans = new Hashtable<String, String>();
            LineNumberReader random = new LineNumberReader(new InputStreamReader(this.getClass().getResourceAsStream(this.FILE_TIPIBEANS)));
            String linea = "";
            String tipo = "";
            String lunghezza = "";
            linea = random.readLine();
            StringTokenizer st = null;
            while (linea != null) {
                st = new StringTokenizer(linea, "=");
                tipo = st.nextToken();
                st = new StringTokenizer(linea, "*");
                st.nextToken();
                lunghezza = st.hasMoreElements() ? st.nextToken() : "0";
                hTipiBeans.put(tipo, lunghezza);
                linea = random.readLine();
                st = null;
            }
            random.close();
            return hTipiBeans;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("File " + this.FILE_TIPIBEANS + " non trovato");
        }
        catch (IOException iOException) {
            throw new IOException("Errore nella lettura del file " + this.FILE_TIPIBEANS);
        }
        catch (Exception exception) {
            throw new IOException("Errore in lettura del file : file " + this.FILE_TIPIBEANS + " errato ");
        }
    }

    public static void main(String[] args) {
        try {
            LeggiRisorse l = new LeggiRisorse();
            Hashtable h = l.leggiTipiBeans();
            System.out.println(h);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }
}

