/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.xades.impl.dom.properties;

import iaik.x509.ocsp.BasicOCSPResponse;
import iaik.x509.ocsp.OCSPResponse;
import iaik.x509.ocsp.ResponseBytes;
import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.DigestMethodImpl;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.URIDereferencerImpl;
import iaik.xml.crypto.xades.DigestAlgAndValue;
import iaik.xml.crypto.xades.OCSPIdentifier;
import iaik.xml.crypto.xades.OCSPRef;
import iaik.xml.crypto.xades.dom.XadesDOMStructure;
import iaik.xml.crypto.xades.impl.dom.properties.DigestAlgAndValueImpl;
import iaik.xml.crypto.xades.impl.dom.properties.OCSPIdentifierImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OCSPRefImpl
extends XadesDOMStructure
implements OCSPRef {
    private byte[] d;
    private InputStream b;
    private DigestAlgAndValueImpl c;
    private OCSPIdentifierImpl a;

    public boolean validate(XMLCryptoContext xMLCryptoContext, Data data) throws XMLSignatureException {
        if (xMLCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null.");
        }
        if (data != null || this.d == null) {
            List list = DOMUtils.distributeNSDeclarations((Element)((Element)this.getNode()));
            if (data == null) {
                data = this.getDigestInputData(xMLCryptoContext);
            }
            if (!(data instanceof OctetStreamData)) {
                throw new XMLSignatureException("Failed to calculate certificate digest. Digest input must be octets.");
            }
            try {
                this.d = this.c.calculateDigestValue(((OctetStreamData)data).getOctetStream(), xMLCryptoContext);
            }
            catch (IOException iOException) {
                throw new XMLSignatureException("Failed to calculate certificate digest.", iOException);
            }
            DOMUtils.withdrawDistributedNSDeclarations((Element)((Element)this.getNode()), (List)list);
        }
        return this.c.getDigestValue() != null ? Arrays.equals(this.c.getDigestValue(), this.d) : false;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof OCSPIdentifierImpl) {
            this.a = (OCSPIdentifierImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof DigestAlgAndValueImpl) {
            this.c = (DigestAlgAndValueImpl)dOMStructure;
        }
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        if (this.c.getDigestValue() == null) {
            try {
                InputStream inputStream = this.b;
                if (inputStream == null) {
                    Data data = this.getDigestInputData(dOMCryptoContext);
                    if (!(data instanceof OctetStreamData)) {
                        throw new MarshalException("Failed to calculate OCSP response digest. Digest input must be octets.");
                    }
                    inputStream = ((OctetStreamData)data).getOctetStream();
                }
                this.c.calculateAndAppendDigestValue(dOMCryptoContext, inputStream);
            }
            catch (XMLSignatureException xMLSignatureException) {
                throw new MarshalException("Failed to calculate OCSP response digest.", xMLSignatureException);
            }
            catch (IOException iOException) {
                throw new MarshalException("Failed to calculate OCSP response digest.", iOException);
            }
        }
        return node3;
    }

    public OCSPIdentifier getOCSPIdentifier() {
        return this.a;
    }

    public String getLocalName() {
        return "OCSPRef";
    }

    public Data getDigestInputData(XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        URIDereferencer uRIDereferencer;
        URIDereferencer uRIDereferencer2 = uRIDereferencer = xMLCryptoContext.getURIDereferencer() != null ? xMLCryptoContext.getURIDereferencer() : new URIDereferencerImpl();
        if (uRIDereferencer == null) {
            throw new XMLSignatureException("No URIDereferencer set in provider");
        }
        try {
            return uRIDereferencer.dereference(this.a, xMLCryptoContext);
        }
        catch (URIReferenceException uRIReferenceException) {
            throw new XMLSignatureException("Failed to dereference URI '" + this.a.getURI() + "'. ", uRIReferenceException);
        }
    }

    public DigestAlgAndValue getDigestAlgAndValue() {
        return this.c;
    }

    protected List getChildStructures() {
        List list = super.getChildStructures();
        list.add(this.a);
        if (this.c != null) {
            list.add(this.c);
        }
        return list;
    }

    public OCSPRefImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
    }

    public OCSPRefImpl(OCSPIdentifierImpl oCSPIdentifierImpl, DigestAlgAndValueImpl digestAlgAndValueImpl) {
        if (oCSPIdentifierImpl == null) {
            throw new NullPointerException("Argument 'ocspIdentifier' must not be null");
        }
        this.a = oCSPIdentifierImpl;
        this.c = digestAlgAndValueImpl;
    }

    public OCSPRefImpl(OCSPIdentifierImpl oCSPIdentifierImpl, DigestMethodImpl digestMethodImpl, InputStream inputStream) {
        if (oCSPIdentifierImpl == null) {
            throw new NullPointerException("Argument 'ocspIdentifier' must not be null");
        }
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null.");
        }
        this.c = new DigestAlgAndValueImpl(digestMethodImpl);
        this.a = oCSPIdentifierImpl;
        this.b = inputStream;
    }

    public OCSPRefImpl(OCSPResponse oCSPResponse, DigestMethodImpl digestMethodImpl, String string) {
        if (digestMethodImpl != null) {
            this.c = new DigestAlgAndValueImpl(digestMethodImpl);
        }
        if (oCSPResponse == null) {
            throw new NullPointerException("Argument 'ocspResponse' must not be null");
        }
        if (oCSPResponse.getResponseStatus() != 0) {
            throw new IllegalArgumentException("Argument 'ocspResponse', response status must be 'successful'");
        }
        ResponseBytes responseBytes = oCSPResponse.getResponseBytes();
        if (!responseBytes.getResponseType().equals((Object)BasicOCSPResponse.responseType)) {
            throw new IllegalArgumentException("Argument 'ocspResponse', response type must be 'BasicOCSPResponse'");
        }
        BasicOCSPResponse basicOCSPResponse = (BasicOCSPResponse)responseBytes.getResponse();
        String string2 = basicOCSPResponse.getResponderID().getName().getName();
        Date date = basicOCSPResponse.getProducedAt();
        this.a = new OCSPIdentifierImpl(string2, date, string);
        this.b = new ByteArrayInputStream(oCSPResponse.getEncoded());
    }
}

