/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantValue;
import com.sun.org.apache.bcel.internal.classfile.FieldOrMethod;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.util.BCELComparator;
import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;

public final class Field
extends FieldOrMethod {
    private static BCELComparator bcelComparator = new BCELComparator(){

        @Override
        public boolean equals(Object o1, Object o2) {
            Field THIS = (Field)o1;
            Field THAT = (Field)o2;
            return Objects.equals(THIS.getName(), THAT.getName()) && Objects.equals(THIS.getSignature(), THAT.getSignature());
        }

        @Override
        public int hashCode(Object o) {
            Field THIS = (Field)o;
            return THIS.getSignature().hashCode() ^ THIS.getName().hashCode();
        }
    };

    public Field(Field c) {
        super(c);
    }

    Field(DataInput file, ConstantPool constant_pool) throws IOException, ClassFormatException {
        super(file, constant_pool);
    }

    public Field(int access_flags, int name_index, int signature_index, Attribute[] attributes, ConstantPool constant_pool) {
        super(access_flags, name_index, signature_index, attributes, constant_pool);
    }

    @Override
    public void accept(Visitor v) {
        v.visitField(this);
    }

    public final ConstantValue getConstantValue() {
        for (Attribute attribute : super.getAttributes()) {
            if (attribute.getTag() != 1) continue;
            return (ConstantValue)attribute;
        }
        return null;
    }

    public final String toString() {
        String access = Utility.accessToString(super.getAccessFlags());
        access = access.isEmpty() ? "" : access + " ";
        String signature = Utility.signatureToString(this.getSignature());
        String name = this.getName();
        StringBuilder buf = new StringBuilder(64);
        buf.append(access).append(signature).append(" ").append(name);
        ConstantValue cv = this.getConstantValue();
        if (cv != null) {
            buf.append(" = ").append(cv);
        }
        for (Attribute attribute : super.getAttributes()) {
            if (attribute instanceof ConstantValue) continue;
            buf.append(" [").append(attribute).append("]");
        }
        return buf.toString();
    }

    public final Field copy(ConstantPool _constant_pool) {
        return (Field)this.copy_(_constant_pool);
    }

    public Type getType() {
        return Type.getReturnType(this.getSignature());
    }

    public static BCELComparator getComparator() {
        return bcelComparator;
    }

    public static void setComparator(BCELComparator comparator) {
        bcelComparator = comparator;
    }

    public boolean equals(Object obj) {
        return bcelComparator.equals(this, obj);
    }

    public int hashCode() {
        return bcelComparator.hashCode(this);
    }
}

