/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTypeTable
extends Attribute {
    private LocalVariable[] local_variable_type_table;

    public LocalVariableTypeTable(LocalVariableTypeTable c) {
        this(c.getNameIndex(), c.getLength(), c.getLocalVariableTypeTable(), c.getConstantPool());
    }

    public LocalVariableTypeTable(int name_index, int length, LocalVariable[] local_variable_table, ConstantPool constant_pool) {
        super((byte)17, name_index, length, constant_pool);
        this.local_variable_type_table = local_variable_table;
    }

    LocalVariableTypeTable(int nameIdx, int len, DataInput input, ConstantPool cpool) throws IOException {
        this(nameIdx, len, (LocalVariable[])null, cpool);
        int local_variable_type_table_length = input.readUnsignedShort();
        this.local_variable_type_table = new LocalVariable[local_variable_type_table_length];
        for (int i = 0; i < local_variable_type_table_length; ++i) {
            this.local_variable_type_table[i] = new LocalVariable(input, cpool);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitLocalVariableTypeTable(this);
    }

    @Override
    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.local_variable_type_table.length);
        for (LocalVariable variable : this.local_variable_type_table) {
            variable.dump(file);
        }
    }

    public final LocalVariable[] getLocalVariableTypeTable() {
        return this.local_variable_type_table;
    }

    public final LocalVariable getLocalVariable(int index) {
        for (LocalVariable variable : this.local_variable_type_table) {
            if (variable.getIndex() != index) continue;
            return variable;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] local_variable_table) {
        this.local_variable_type_table = local_variable_table;
    }

    @Override
    public final String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.local_variable_type_table.length; ++i) {
            buf.append(this.local_variable_type_table[i].toStringShared(true));
            if (i >= this.local_variable_type_table.length - 1) continue;
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public Attribute copy(ConstantPool constant_pool) {
        LocalVariableTypeTable c = (LocalVariableTypeTable)this.clone();
        c.local_variable_type_table = new LocalVariable[this.local_variable_type_table.length];
        for (int i = 0; i < this.local_variable_type_table.length; ++i) {
            c.local_variable_type_table[i] = this.local_variable_type_table[i].copy();
        }
        c.setConstantPool(constant_pool);
        return c;
    }

    public final int getTableLength() {
        return this.local_variable_type_table == null ? 0 : this.local_variable_type_table.length;
    }
}

