/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.UnknownAttributeValue;
import iaik.pkcs.pkcs9.ChallengePassword;
import iaik.pkcs.pkcs9.ExtensionRequest;
import iaik.utils.CryptoUtils;
import iaik.utils.ObjectFactory;
import iaik.utils.Util;

public class Attribute
implements ASN1Type {
    static /* synthetic */ Class f;
    static /* synthetic */ Class e;
    static /* synthetic */ Class g;
    private boolean c;
    private AttributeValue[] a;
    private ObjectID b;
    private static final Class h;
    private static ObjectFactory d;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.b != null) {
            stringBuffer.append(String.valueOf(this.b.getName()) + ":\n");
        }
        if (this.a != null && this.a.length > 0) {
            int n2 = 0;
            while (n2 < this.a.length) {
                stringBuffer.append(this.a[n2].toString());
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object(boolean bl) {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.b);
        SET sET = new SET(bl);
        if (this.a != null) {
            int n2 = 0;
            while (n2 < this.a.length) {
                try {
                    sET.addComponent(this.a[n2].toASN1Object());
                }
                catch (CodingException codingException) {
                    throw new RuntimeException("ASN.1 component error: " + codingException.toString());
                }
                ++n2;
            }
        }
        sEQUENCE.addComponent(sET);
        return sEQUENCE;
    }

    public ASN1Object toASN1Object() {
        return this.toASN1Object(this.c);
    }

    public void setAttributeValue(AttributeValue attributeValue) throws IllegalArgumentException, CodingException {
        if (attributeValue != null) {
            ObjectID objectID = attributeValue.getAttributeType();
            if (this.b != null) {
                if (!this.b.equals(objectID)) {
                    throw new IllegalArgumentException("Cannot set AttributeValue: Invalid type: " + objectID.getName() + ". Expected " + this.b.getName());
                }
            } else {
                this.b = objectID;
            }
            this.a = new AttributeValue[]{attributeValue};
            return;
        }
        this.a = null;
    }

    public static void register(ObjectID objectID, Class clazz) {
        if (!h.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz + " is no AttributeValue implementation!");
        }
        d.register(objectID, clazz);
    }

    public int hashCode() {
        if (this.b == null) {
            return 0;
        }
        return this.b.hashCode();
    }

    public ASN1Object[] getValue() {
        ASN1Object[] aSN1ObjectArray = null;
        if (this.a != null) {
            aSN1ObjectArray = new ASN1Object[this.a.length];
            int n2 = 0;
            while (n2 < this.a.length) {
                try {
                    aSN1ObjectArray[n2] = this.a[n2].toASN1Object();
                }
                catch (CodingException codingException) {
                    throw new RuntimeException("ASN.1 component error: " + codingException.toString());
                }
                ++n2;
            }
        }
        return aSN1ObjectArray;
    }

    public ObjectID getType() {
        return this.b;
    }

    public AttributeValue[] getAttributeValues() throws CodingException {
        if (this.a == null) {
            return new AttributeValue[0];
        }
        return this.a;
    }

    public AttributeValue getAttributeValue() throws CodingException {
        if (this.a == null || this.a.length == 0) {
            return null;
        }
        return this.a[0];
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof Attribute) {
            Attribute attribute = (Attribute)object;
            if (this.b != null && attribute.b != null) {
                bl = this.b.equals(attribute.b);
            } else {
                boolean bl2 = bl = this.b == null && attribute.b == null;
            }
            if (bl) {
                bl = this.a != null && attribute.a != null ? (this.a.length == attribute.a.length ? CryptoUtils.equalsBlock(DerCoder.encode(this.toASN1Object()), DerCoder.encode(attribute.toASN1Object())) : false) : this.a == null && attribute.a == null;
            }
        }
        return bl;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = (ObjectID)aSN1Object.getComponentAt(0);
        SET sET = (SET)aSN1Object.getComponentAt(1);
        this.a = new AttributeValue[sET.countComponents()];
        int n2 = 0;
        while (n2 < sET.countComponents()) {
            ASN1Object aSN1Object2 = sET.getComponentAt(n2);
            try {
                this.a[n2] = Attribute.create(this.b);
            }
            catch (InstantiationException instantiationException) {
                this.a[n2] = new UnknownAttributeValue(this.b);
            }
            this.a[n2].decode(aSN1Object2);
            ++n2;
        }
    }

    public static AttributeValue create(ObjectID objectID) throws InstantiationException {
        return (AttributeValue)d.create(objectID);
    }

    public void addAttributeValue(AttributeValue attributeValue) throws IllegalArgumentException, CodingException {
        if (attributeValue == null) {
            throw new NullPointerException("attributeValue must not be null!");
        }
        ObjectID objectID = attributeValue.getAttributeType();
        if (this.b != null) {
            if (!this.b.equals(objectID)) {
                throw new IllegalArgumentException("Cannot add AttributeValue: Invalid type: " + objectID.getName() + ". Expected " + this.b.getName());
            }
        } else {
            this.b = objectID;
        }
        if (this.a == null) {
            this.a = new AttributeValue[1];
        } else if (attributeValue.multipleAllowed()) {
            this.a = (AttributeValue[])Util.resizeArray(this.a, this.a.length + 1);
        } else if (this.a.length > 1) {
            this.a = new AttributeValue[1];
        }
        this.a[this.a.length - 1] = attributeValue;
    }

    public Attribute(AttributeValue attributeValue, boolean bl) throws CodingException {
        if (attributeValue == null) {
            throw new NullPointerException("attributeValue must not be null!");
        }
        this.b = attributeValue.getAttributeType();
        this.a = new AttributeValue[]{attributeValue};
        this.c = bl;
    }

    public Attribute(AttributeValue attributeValue) throws CodingException {
        this(attributeValue, false);
    }

    public Attribute(ObjectID objectID, ASN1Object[] aSN1ObjectArray, boolean bl) {
        this.b = objectID;
        if (aSN1ObjectArray != null) {
            this.a = new AttributeValue[aSN1ObjectArray.length];
            int n2 = 0;
            while (n2 < aSN1ObjectArray.length) {
                this.a[n2] = new UnknownAttributeValue(objectID, aSN1ObjectArray[n2]);
                ++n2;
            }
        }
        this.c = bl;
    }

    public Attribute(ObjectID objectID, ASN1Object[] aSN1ObjectArray) {
        this(objectID, aSN1ObjectArray, false);
    }

    public Attribute(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public Attribute() {
        this.c = false;
    }

    static {
        d = new ObjectFactory();
        h = g != null ? g : (g = Attribute.a("iaik.asn1.structures.AttributeValue"));
        Attribute.register(ExtensionRequest.oid, e != null ? e : (e = Attribute.a("iaik.pkcs.pkcs9.ExtensionRequest")));
        Attribute.register(ChallengePassword.oid, f != null ? f : (f = Attribute.a("iaik.pkcs.pkcs9.ChallengePassword")));
    }
}

