/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.x509.X509CRL;
import java.security.cert.CRLException;

public class CRLBag
extends SafeBag {
    protected ASN1Object crl_type = ObjectID.x509Crl;
    protected X509CRL crl;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CRL type: " + this.crl.getType() + "\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.crl_type);
        try {
            OCTET_STRING oCTET_STRING = new OCTET_STRING(this.crl.getEncoded());
            sEQUENCE.addComponent(new CON_SPEC(0, oCTET_STRING));
        }
        catch (CRLException cRLException) {
            throw new CodingException("Error encoding CRL!" + cRLException);
        }
        return sEQUENCE;
    }

    public static X509CRL[] getCertificates(CRLBag[] cRLBagArray) {
        X509CRL[] x509CRLArray = new X509CRL[cRLBagArray.length];
        int n2 = 0;
        while (n2 < x509CRLArray.length) {
            x509CRLArray[n2] = cRLBagArray[n2].getCRL();
            ++n2;
        }
        return x509CRLArray;
    }

    public X509CRL getCRL() {
        return this.crl;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.crl_type = aSN1Object.getComponentAt(0);
        ASN1Object aSN1Object2 = (ASN1Object)aSN1Object.getComponentAt(1).getValue();
        X509CRL x509CRL = new X509CRL();
        x509CRL.decode(aSN1Object2);
        this.crl = x509CRL;
    }

    public CRLBag(X509CRL x509CRL, String string, byte[] byArray) {
        super(string, byArray);
        this.crl = x509CRL;
        this.j = ObjectID.pkcs12_crlBag;
    }

    public CRLBag(X509CRL x509CRL) {
        this.crl = x509CRL;
        this.j = ObjectID.pkcs12_crlBag;
    }

    protected CRLBag() {
        this.j = ObjectID.pkcs12_crlBag;
    }
}

