/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs8;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.CryptoUtils;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;

public abstract class PrivateKeyInfo
implements Cloneable,
PrivateKey,
ASN1Type,
Serializable {
    protected AlgorithmID private_key_algorithm;
    ASN1 b;
    int a;

    public void writeTo(OutputStream outputStream) throws IOException {
        this.b.writeTo(outputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("This PrivateKeyInfo contains a ");
        stringBuffer.append(String.valueOf(this.private_key_algorithm.getName()) + " key.");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        return this.b.toASN1Object();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.b = new ASN1(objectInputStream);
            this.a();
            return;
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to restore PrivateKeyInfo: " + codingException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Unable to restore PrivateKeyInfo: " + invalidKeyException.toString());
        }
    }

    public int hashCode() {
        return Util.calculateHashCode(this.getEncoded());
    }

    public static PrivateKey getPrivateKey(byte[] byArray, String string) throws InvalidKeyException {
        try {
            return PrivateKeyInfo.getPrivateKey(DerCoder.decode(byArray), string);
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PrivateKeyInfo: " + codingException.toString());
        }
    }

    public static PrivateKey getPrivateKey(byte[] byArray) throws InvalidKeyException {
        return PrivateKeyInfo.getPrivateKey(byArray, null);
    }

    public static PrivateKey getPrivateKey(ASN1Object aSN1Object, String string) throws InvalidKeyException {
        AlgorithmID algorithmID = null;
        try {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(DerCoder.encode(aSN1Object));
            algorithmID = new AlgorithmID(aSN1Object.getComponentAt(1));
            KeyFactory keyFactory = algorithmID.getKeyFactoryInstance(string);
            return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("PublicKey algorithm not implemented: " + algorithmID.getName());
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new InvalidKeyException("Can't parse PrivateKeyInfo: " + invalidKeySpecException.toString());
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PrivateKeyInfo: " + codingException.toString());
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Can't parse PrivateKeyInfo: " + exception.toString());
        }
    }

    public static PrivateKey getPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        return PrivateKeyInfo.getPrivateKey(aSN1Object, null);
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] getEncoded() {
        return this.b.toByteArray();
    }

    public AlgorithmID getAlgorithmID() {
        return this.private_key_algorithm;
    }

    public abstract String getAlgorithm();

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        return CryptoUtils.equalsBlock(this.getEncoded(), ((PrivateKey)object).getEncoded());
    }

    protected abstract byte[] encode();

    protected abstract void decode(byte[] var1) throws InvalidKeyException;

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = new ASN1(aSN1Object);
        try {
            this.a();
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CodingException(invalidKeyException.toString());
        }
    }

    private void a() throws InvalidKeyException {
        try {
            this.a = ((BigInteger)this.b.getComponentAt(0).getValue()).intValue();
            this.private_key_algorithm = new AlgorithmID(this.b.getComponentAt(1));
            this.decode((byte[])this.b.getComponentAt(2).getValue());
            return;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + exception.toString());
        }
    }

    protected void createPrivateKeyInfo() {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.a));
            sEQUENCE.addComponent(this.private_key_algorithm.toASN1Object());
            sEQUENCE.addComponent(new OCTET_STRING(this.encode()));
            this.b = new ASN1(sEQUENCE);
            return;
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("CodingException!");
        }
    }

    public Object clone() {
        PrivateKeyInfo privateKeyInfo = null;
        try {
            privateKeyInfo = (PrivateKeyInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return privateKeyInfo;
    }

    public PrivateKeyInfo(byte[] byArray) throws InvalidKeyException {
        try {
            this.b = new ASN1(byArray);
            this.a();
            return;
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public PrivateKeyInfo(InputStream inputStream) throws IOException, InvalidKeyException {
        try {
            this.b = new ASN1(inputStream);
            this.a();
            return;
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public PrivateKeyInfo(ASN1Object aSN1Object) throws InvalidKeyException {
        try {
            this.b = new ASN1(aSN1Object);
            this.a();
            return;
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    protected PrivateKeyInfo() {
    }
}

