/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.attributes;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AttributeValue;
import iaik.utils.Util;
import iaik.x509.attr.SecurityCategory;
import iaik.x509.attr.UnknownSecurityCategory;
import java.util.Enumeration;
import java.util.Hashtable;

public class Clearance
extends AttributeValue {
    private SecurityCategory[] b;
    private int d = 2;
    private ObjectID c;
    private static Hashtable a;
    public static final int TOP_SECRET = 32;
    public static final int SECRET = 16;
    public static final int CONFIDENTIAL = 8;
    public static final int RESTRICTED = 4;
    public static final int UNCLASSIFIED = 2;
    public static final int UNMARKED = 1;
    public static final ObjectID oid;

    public String toString(boolean bl) {
        Object v2;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.c != null) {
            stringBuffer.append("policy-id: " + this.c.getName());
        }
        stringBuffer.append("\nclass-list: " + this.getClassListAsBinaryString());
        if (a != null && (v2 = a.get(new Integer(this.d))) != null) {
            stringBuffer.append(" (" + v2 + ")");
        }
        if (this.b != null && this.b.length > 0) {
            int n2 = this.b.length;
            stringBuffer.append("\nThis Clearance contains " + n2 + " security categor" + (n2 == 1 ? "y:" : "ies:"));
            int n3 = 0;
            while (n3 < n2) {
                if (bl) {
                    stringBuffer.append("\nSecurityCategory No " + (n3 + 1) + " (type: " + this.b[n3].getType().getName() + "): {\n");
                    Util.printIndented(this.b[n3].toString(), true, "  ", stringBuffer);
                    stringBuffer.append("\n}");
                } else {
                    if (n3 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.b[n3].getType().getName());
                }
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.c == null) {
            throw new NullPointerException("Cannot encode Clearance. Missing policy id!");
        }
        boolean bl = true;
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new CON_SPEC(0, this.c, bl));
        if (this.d != 2) {
            StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.d));
            stringBuffer.reverse();
            sEQUENCE.addComponent(new CON_SPEC(1, new BIT_STRING(stringBuffer.toString()), bl));
        }
        if (this.b != null && this.b.length > 0) {
            boolean bl2 = true;
            SET sET = new SET(bl2);
            int n2 = 0;
            while (n2 < this.b.length) {
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                ((ASN1Object)sEQUENCE2).addComponent(new CON_SPEC(0, this.b[n2].getType(), bl));
                ((ASN1Object)sEQUENCE2).addComponent(this.b[n2].toASN1Object());
                sET.addComponent(sEQUENCE2);
                ++n2;
            }
            sEQUENCE.addComponent(new CON_SPEC(2, sET, bl));
        }
        return sEQUENCE;
    }

    public static void setSecurityClassificationName(int n2, String string) {
        if (n2 < 64) {
            throw new IllegalArgumentException("Bits 0 through 5 are reserved for basic security classification hierachy.");
        }
        String string2 = Integer.toBinaryString(n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < string2.length()) {
            if (string2.charAt(n4) == '1' && ++n3 > 1) {
                StringBuffer stringBuffer = new StringBuffer(string2);
                stringBuffer.reverse();
                throw new IllegalArgumentException("Invalid security classification value: " + stringBuffer.toString() + ". Only one bit must be set!");
            }
            ++n4;
        }
        a.put(new Integer(n2), string);
    }

    public void setSecurityCategories(SecurityCategory[] securityCategoryArray) {
        if (securityCategoryArray != null) {
            this.b = securityCategoryArray;
            return;
        }
        this.b = null;
    }

    public void setClassList(int n2) throws IllegalArgumentException {
        if (n2 < 1) {
            throw new IllegalArgumentException("Invalid classList value: " + n2 + ". Must be > 0");
        }
        this.d = n2;
    }

    public boolean isSecurityClassificationValueSet(int n2) {
        return (this.d & n2) != 0;
    }

    public boolean isClassListBitSet(int n2) {
        boolean bl = false;
        String string = this.getClassListAsBinaryString();
        if (n2 < string.length()) {
            bl = string.charAt(n2) == '1';
        }
        return bl;
    }

    public static String getSecurityClassificationName(int n2) {
        Object v2;
        if (a != null && (v2 = a.get(new Integer(n2))) instanceof String) {
            return (String)v2;
        }
        return null;
    }

    public SecurityCategory[] getSecurityCategories() {
        if (this.b == null) {
            return new SecurityCategory[0];
        }
        return this.b;
    }

    public ObjectID getPolicyId() {
        return this.c;
    }

    public String getClassListBitNames() {
        StringBuffer stringBuffer = new StringBuffer();
        if (a != null) {
            Enumeration enumeration = a.keys();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                Integer n3 = (Integer)enumeration.nextElement();
                if ((n3 & this.d) == 0) continue;
                if (n2++ > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(a.get(n3));
            }
        }
        return stringBuffer.toString();
    }

    public boolean[] getClassListAsBooleanArray() {
        StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.d));
        int n2 = stringBuffer.length();
        boolean[] blArray = new boolean[n2 < 6 ? 6 : n2];
        int n3 = this.d;
        int n4 = 0;
        while (n3 != 0) {
            if ((n3 & 1) != 0) {
                blArray[n4] = true;
            }
            ++n4;
            n3 >>= 1;
        }
        return blArray;
    }

    public String getClassListAsBinaryString() {
        StringBuffer stringBuffer = new StringBuffer(Integer.toBinaryString(this.d));
        stringBuffer.reverse();
        int n2 = stringBuffer.length();
        if (n2 < 6) {
            int n3 = n2;
            while (n3 < 6) {
                stringBuffer.append('0');
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public int getClassList() {
        return this.d;
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new NullPointerException("Cannot decode null!");
        }
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid ASN.1 type: " + aSN1Object.getAsnType().getName() + ". Expected SEQUENCE!");
        }
        int n2 = aSN1Object.countComponents();
        if (n2 < 1 || n2 > 3) {
            throw new CodingException("Invalid number of components: " + n2);
        }
        int n3 = 2;
        SecurityCategory[] securityCategoryArray = null;
        ASN1Object aSN1Object2 = aSN1Object.getComponentAt(0);
        if (!aSN1Object2.isA(ASN.CON_SPEC)) {
            throw new CodingException("Invalid ASN.1 type (" + aSN1Object.getAsnType().getName() + ") of first (policyID) component. Expected CON_SPEC!");
        }
        CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object2;
        int n4 = cON_SPEC.getAsnType().getTag();
        if (n4 != 0) {
            throw new CodingException("Invalid tag number (" + n4 + ") of first (policyID) component. Expected 0!");
        }
        cON_SPEC.forceImplicitlyTagged(ASN.ObjectID);
        ObjectID objectID = (ObjectID)cON_SPEC.getValue();
        if (n2 > 1) {
            int n5 = 1;
            while (n5 < n2) {
                ASN1Object aSN1Object3;
                aSN1Object2 = aSN1Object.getComponentAt(n5);
                if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                    throw new CodingException("Invalid ASN.1 type (" + aSN1Object.getAsnType().getName() + ") of component " + (n5 + 1) + ". Expected CON_SPEC!");
                }
                cON_SPEC = (CON_SPEC)aSN1Object2;
                n4 = cON_SPEC.getAsnType().getTag();
                if (n4 == 1) {
                    cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                    aSN1Object3 = (BIT_STRING)cON_SPEC.getValue();
                    StringBuffer stringBuffer = new StringBuffer(((BIT_STRING)aSN1Object3).getBinaryString()).reverse();
                    n3 = Integer.parseInt(stringBuffer.toString(), 2);
                } else if (n4 == 2) {
                    cON_SPEC.forceImplicitlyTagged(ASN.SET);
                    aSN1Object3 = (SET)cON_SPEC.getValue();
                    int n6 = ((ConstructedType)aSN1Object3).countComponents();
                    securityCategoryArray = new SecurityCategory[n6];
                    int n7 = 0;
                    while (n7 < n6) {
                        SecurityCategory securityCategory;
                        ASN1Object aSN1Object4 = ((ConstructedType)aSN1Object3).getComponentAt(n7);
                        cON_SPEC = (CON_SPEC)aSN1Object4.getComponentAt(0);
                        cON_SPEC.forceImplicitlyTagged(ASN.ObjectID);
                        ObjectID objectID2 = (ObjectID)cON_SPEC.getValue();
                        try {
                            securityCategory = SecurityCategory.create(objectID2);
                        }
                        catch (InstantiationException instantiationException) {
                            securityCategory = new UnknownSecurityCategory(objectID2);
                        }
                        securityCategory.decode(aSN1Object4.getComponentAt(1));
                        securityCategoryArray[n7] = securityCategory;
                        ++n7;
                    }
                } else {
                    throw new CodingException("Invalid component tag: " + n4);
                }
                ++n5;
            }
        }
        this.c = objectID;
        this.d = n3;
        this.b = securityCategoryArray;
    }

    public Clearance(ObjectID objectID) {
        this();
        if (objectID == null) {
            throw new NullPointerException("policy id must not be null!");
        }
        this.c = objectID;
    }

    public Clearance(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public Clearance() {
    }

    static {
        oid = ObjectID.clearance;
        a = new Hashtable(10);
        a.put(new Integer(1), "unmarked");
        a.put(new Integer(2), "unclassified");
        a.put(new Integer(4), "restricted");
        a.put(new Integer(8), "confidential");
        a.put(new Integer(16), "secret");
        a.put(new Integer(32), "topSecret");
    }
}

