/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.ChoiceOfTime;
import iaik.asn1.structures.GeneralName;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.ocsp.CertStatus;
import iaik.x509.ocsp.CertificateResponse;
import iaik.x509.ocsp.OCSPException;
import iaik.x509.ocsp.OCSPExtensions;
import iaik.x509.ocsp.ReqCert;
import iaik.x509.ocsp.extensions.ArchiveCutoff;
import iaik.x509.ocsp.extensions.CrlID;
import java.util.Date;
import java.util.Enumeration;

public class SingleResponse
implements CertificateResponse {
    OCSPExtensions d;
    ChoiceOfTime c;
    ChoiceOfTime a;
    CertStatus e;
    ReqCert b;

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("reqCert: {\n");
        Util.printIndented(this.b.toString(), true, "  ", stringBuffer);
        stringBuffer.append("\n}");
        stringBuffer.append("\ncertStatus: {\n");
        Util.printIndented(this.e.toString(), true, "  ", stringBuffer);
        stringBuffer.append("\n}");
        stringBuffer.append("\nthisUpdate: " + this.a);
        if (this.c != null) {
            stringBuffer.append("\nnextUpdate: " + this.c);
        }
        if (this.d != null) {
            if (bl) {
                stringBuffer.append("\nextensions:\n");
                Util.printIndented(this.d.toString(), true, "  ", stringBuffer);
                stringBuffer.append("\n}");
            } else {
                stringBuffer.append("\nExtensions: " + this.d.countExtensions());
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(false);
    }

    public ASN1Object toASN1Object() throws CodingException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(this.b.toASN1Object());
            sEQUENCE.addComponent(this.e.toASN1Object());
            sEQUENCE.addComponent(this.a.toASN1Object());
            if (this.c != null) {
                sEQUENCE.addComponent(new CON_SPEC(0, this.c.toASN1Object()));
            }
            if (this.d != null) {
                sEQUENCE.addComponent(new CON_SPEC(1, this.d.toASN1Object()));
            }
            return sEQUENCE;
        }
        catch (Exception exception) {
            throw new CodingException(exception.getMessage());
        }
    }

    public void setNextUpdate(Date date) {
        this.c = new ChoiceOfTime(date);
        this.c.setEncodingType(ASN.GeneralizedTime);
    }

    public void setCrlID(CrlID crlID) throws X509ExtensionException {
        this.addExtension(crlID);
    }

    public void setArchiveCutoff(Date date) throws X509ExtensionException {
        this.addExtension(new ArchiveCutoff(date));
    }

    public boolean removeExtension(ObjectID objectID) {
        if (this.d == null) {
            return false;
        }
        return this.d.removeExtension(objectID);
    }

    public void removeAllExtensions() {
        if (this.d != null) {
            this.d.removeAllExtensions();
        }
        this.d = null;
    }

    public Enumeration listExtensions() {
        if (this.d == null) {
            return null;
        }
        return this.d.listExtensions();
    }

    public boolean isResponseFor(ReqCert reqCert) {
        return this.b.equals(reqCert);
    }

    public boolean isResponseFor(X509Certificate x509Certificate, X509Certificate x509Certificate2, GeneralName generalName) throws OCSPException {
        return this.b.isReqCertFor(x509Certificate, x509Certificate2, generalName);
    }

    public boolean hasUnsupportedCriticalExtension() {
        if (this.d == null) {
            return false;
        }
        return this.d.hasUnsupportedCriticalExtension();
    }

    public boolean hasExtensions() {
        if (this.d == null) {
            return false;
        }
        return this.d.hasExtensions();
    }

    public Date getThisUpdate() {
        if (this.a == null) {
            return null;
        }
        return this.a.getDate();
    }

    public ReqCert getReqCert() {
        return this.b;
    }

    public Date getNextUpdate() {
        if (this.c == null) {
            return null;
        }
        return this.c.getDate();
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        if (this.d == null) {
            return null;
        }
        return this.d.getExtension(objectID);
    }

    public CrlID getCrlID() throws X509ExtensionInitException {
        return (CrlID)this.getExtension(CrlID.oid);
    }

    public CertStatus getCertStatus() {
        return this.e;
    }

    public Date getArchiveCutoff() throws X509ExtensionInitException {
        ArchiveCutoff archiveCutoff = (ArchiveCutoff)this.getExtension(ArchiveCutoff.oid);
        if (archiveCutoff == null) {
            return null;
        }
        return archiveCutoff.getCutoffTime();
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = new ReqCert(aSN1Object.getComponentAt(0));
        if (this.b == null) {
            throw new CodingException("Cannot create SingleResponse. Missing reqCert!");
        }
        this.e = new CertStatus(aSN1Object.getComponentAt(1));
        if (this.e == null) {
            throw new CodingException("Cannot create SingleResponse. Missing CertStatus!");
        }
        this.a = new ChoiceOfTime(aSN1Object.getComponentAt(2));
        CON_SPEC cON_SPEC = null;
        int n2 = 3;
        while (n2 < aSN1Object.countComponents()) {
            cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(n2);
            int n3 = cON_SPEC.getAsnType().getTag();
            if (n3 == 0) {
                this.c = new ChoiceOfTime((ASN1Object)cON_SPEC.getValue());
            } else if (n3 == 1) {
                try {
                    this.d = new OCSPExtensions((ASN1Object)cON_SPEC.getValue());
                }
                catch (X509ExtensionException x509ExtensionException) {
                    throw new CodingException(x509ExtensionException.getMessage());
                }
            } else {
                throw new CodingException("Invalid context specific tag in SingleResponse encoding: " + n3);
            }
            ++n2;
        }
    }

    public int countExtensions() {
        if (this.d == null) {
            return 0;
        }
        return this.d.countExtensions();
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.d == null) {
            this.d = new OCSPExtensions();
        }
        this.d.addExtension(v3Extension);
    }

    public SingleResponse(ReqCert reqCert, CertStatus certStatus, Date date) {
        if (reqCert == null) {
            throw new IllegalArgumentException("Cannot create SingleResponse. Missing ReqCert!");
        }
        this.b = reqCert;
        if (certStatus == null) {
            throw new IllegalArgumentException("Cannot create SingleResponse. Missing CertStatus!");
        }
        this.e = certStatus;
        if (date == null) {
            throw new IllegalArgumentException("Cannot create SingleResponse. Missing thisUpdate date!");
        }
        this.a = new ChoiceOfTime(date);
        this.a.setEncodingType(ASN.GeneralizedTime);
    }

    public SingleResponse(ASN1Object aSN1Object) throws X509ExtensionException, CodingException {
        this.decode(aSN1Object);
    }

    public SingleResponse() {
    }
}

