/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.core.commands.handlers;

import it.sogei.rcp.core.entity.ConfigurationItems;
import it.sogei.rcp.core.properties.Messages;
import it.sogei.rcp.core.util.RCPHandlerUtil;
import it.sogei.rcp.filesystemutil.FileSystemUtil;
import it.sogei.rcp.interfaces.IAbsolutePath;
import it.sogei.rcp.interfaces.IRelativePath;
import it.sogei.rcp.util.AbsolutePath;
import it.sogei.rcp.util.RCPException;
import it.sogei.rcp.util.RelativePath;
import it.sogei.rcp.zip.exceptions.ZipException;
import it.sogei.rcp.zip.factory.ZipFactory;
import it.sogei.rcp.zip.interfaces.IZipUtil;
import it.sogei.utilities.log4j.LogUtil;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class ExportLogHandler
extends AbstractHandler {
    private static String FILE = "it.sogei.rcp.core.export.log.file";
    private static String[] LOG_EXTENSIONS = new String[]{"*.log"};
    private static String[] ZIP_EXTENSIONS = new String[]{"*.zip"};

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String param = event.getParameter(FILE);
        String src = "";
        boolean isZip = false;
        LogUtil.log((Object)((Object)this), (int)1, (String)("export log:" + event.getCommand().getId() + " parameter:" + param));
        if (param != null) {
            String filename = "";
            String estension = "";
            FileDialog fd = new FileDialog(Display.getDefault().getActiveShell(), 8192);
            if (param.equals("LOG")) {
                src = "logs/rcp.log";
                filename = ConfigurationItems.getAppName();
                estension = ".log";
                fd.setFilterExtensions(LOG_EXTENSIONS);
            } else if (param.equals("SESSIONLOG")) {
                src = "logs/sessionrcp.log";
                filename = ConfigurationItems.getAppName();
                estension = ".log";
                fd.setFilterExtensions(LOG_EXTENSIONS);
            } else if (param.equals("LOGZIP")) {
                src = "logs/rcp.log";
                isZip = true;
                filename = ConfigurationItems.getAppName();
                estension = ".zip";
                fd.setFilterExtensions(ZIP_EXTENSIONS);
            }
            fd.setFileName(String.valueOf(filename) + estension);
            fd.setOverwrite(true);
            if (!new File(String.valueOf(RCPHandlerUtil.getWorkspaceRoot()) + src).exists()) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ExportLogHandler_Error, (String)("File " + src + Messages.ExportLogHandler_NotFound));
            } else {
                String dest = fd.open();
                LogUtil.log((Object)((Object)this), (int)1, (String)("in: " + src + " out:" + dest));
                if (dest != null) {
                    try {
                        this.createFile(src, dest, isZip);
                    }
                    catch (IOException e) {
                        LogUtil.log((Object)((Object)this), (int)4, (String)"errore IO", (Throwable)e);
                    }
                } else {
                    LogUtil.log((Object)((Object)this), (int)2, (String)"azione annullata dall'utente");
                }
            }
        } else {
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.ExportLogHandler_Error, (String)Messages.ExportLogHandler_OperationFailed);
        }
        return null;
    }

    public void createFile(String src, String dest, boolean isZip) throws IOException {
        LogUtil.log((Object)((Object)this), (int)2, (String)("e' un file zip:" + isZip));
        if (isZip) {
            this.zipFile(src, dest);
        } else {
            this.copyFile(src, dest);
        }
    }

    public void zipFile(String src, String dest) throws IOException {
        ZipFactory zf = ZipFactory.getInstance();
        IZipUtil zipUtil = zf.getZipUtil();
        FileSystemUtil fsu = new FileSystemUtil();
        try {
            RelativePath relativePathSrc = new RelativePath(src);
            AbsolutePath absolutePathDest = new AbsolutePath(dest);
            RelativePath relativePathTmp = new RelativePath(String.valueOf(relativePathSrc.getFolderPath()) + absolutePathDest.getFileName());
            LogUtil.log((Object)((Object)this), (int)2, (String)("inserisco file: " + relativePathSrc.getFileName() + " in temporaneo " + relativePathTmp.getFolderPath() + absolutePathDest.getFileName()), (boolean)true);
            zipUtil.compress((IRelativePath)relativePathTmp, (IRelativePath)relativePathSrc);
            fsu.exportFile((IRelativePath)relativePathTmp, (IAbsolutePath)absolutePathDest);
            fsu.deleteFile((IRelativePath)relativePathTmp);
            LogUtil.log((Object)((Object)this), (int)2, (String)("log compresso creato in: " + dest));
        }
        catch (ZipException zipException) {
            LogUtil.log((Object)((Object)this), (int)4, (String)(String.valueOf(Messages.ExportLogHandler_ExceptionCreationIn) + dest), (boolean)true);
        }
        catch (RCPException rCPException) {
            LogUtil.log((Object)((Object)this), (int)4, (String)(String.valueOf(Messages.ExportLogHandler_ExceptionCreationIn) + dest), (boolean)true);
        }
    }

    public void copyFile(String src, String dest) throws IOException {
        try {
            RelativePath relativePathSrc = new RelativePath(src);
            AbsolutePath absolutePathDest = new AbsolutePath(dest);
            FileSystemUtil fsu = new FileSystemUtil();
            fsu.exportFile((IRelativePath)relativePathSrc, (IAbsolutePath)absolutePathDest);
        }
        catch (RCPException rCPException) {
            LogUtil.log((Object)((Object)this), (int)4, (String)(String.valueOf(Messages.ExportLogHandler_ExceptionCreationIn) + dest), (boolean)true);
        }
    }
}

