/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2005;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class CheckedBufferedReader
extends BufferedReader {
    private Checksum cksum;
    private char commentChar;
    public static final char DEFAULT_COMMENT_CHAR = '#';

    public CheckedBufferedReader(InputStream inStream) throws FileNotFoundException {
        this((Reader)new InputStreamReader(inStream), new CRC32());
    }

    public CheckedBufferedReader(Reader reader) {
        this(reader, new CRC32());
    }

    public CheckedBufferedReader(Reader reader, Checksum cksum) {
        super(reader);
        this.cksum = cksum;
        this.commentChar = (char)35;
    }

    public long getCheckValue() {
        return this.cksum.getValue();
    }

    public boolean isCommentLine(String line) {
        if (line.length() == 0) {
            return true;
        }
        return line.charAt(0) == this.commentChar;
    }

    public void readAll() throws IOException {
        while (this.readLine() != null) {
        }
    }

    public String readLine() throws IOException {
        String line = super.readLine();
        if (line != null && !this.isCommentLine(line)) {
            this.cksum.update(line.getBytes(), 0, line.getBytes().length);
        }
        return line;
    }

    public void setCommentChar(char newChar) {
        this.commentChar = newChar;
    }
}

