/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.security.login.db;

import it.sogei.rcp.database.handler.DerbyHandler;
import it.sogei.rcp.security.login.beans.RuoloBean;
import it.sogei.rcp.security.login.beans.UtentiBean;
import it.sogei.rcp.security.login.utils.PropertiesConfig;
import it.sogei.utilities.log4j.LogUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class DesktopDB {
    public String driver = "org.apache.derby.jdbc.EmbeddedDriver";
    public String protocol = "jdbc:derby:";
    private Connection conn = null;
    private Statement stmt = null;
    String dbname = null;
    String tableNameU = null;
    String tableNameR = null;
    DerbyHandler dbhandler;
    public String pathdb = String.valueOf(System.getProperty("user.dir")) + File.separator + "databases" + File.separator;

    public DesktopDB() {
        this.dbhandler = new DerbyHandler("it.sogei.rcp.security.login");
        try {
            this.dbname = PropertiesConfig.getString("dbname");
            this.tableNameU = PropertiesConfig.getString("tableNameU");
            this.tableNameR = PropertiesConfig.getString("tableNameR");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean createConnection() throws SQLException {
        boolean flag = false;
        try {
            this.dbhandler.startDB();
            this.conn = this.dbhandler.getDBConnection(PropertiesConfig.getString("dbname"));
            flag = true;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return flag;
    }

    public boolean createDb() throws SQLException {
        boolean flag = false;
        try {
            this.dbhandler.startDB();
            this.dbhandler.createDB(PropertiesConfig.getString("dbname"));
            flag = true;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return flag;
    }

    public UtentiBean[] selectUsers() throws SQLException {
        this.createConnection();
        UtentiBean[] users = null;
        UtentiBean user = null;
        ArrayList<UtentiBean> usersList = new ArrayList<UtentiBean>();
        try {
            this.stmt = this.conn.createStatement();
            ResultSet results = this.stmt.executeQuery("select * from " + this.tableNameU);
            while (results.next()) {
                user = new UtentiBean();
                user.setNome(results.getString(1));
                user.setPath(results.getString(3));
                user.setPassword(results.getString(4));
                user.setRuoli(this.getUserRoles(user.getNome()));
                usersList.add(user);
                LogUtil.log((Object)this, (int)1, (String)("user: " + user.getNome() + " " + user.getPath()));
            }
            users = new UtentiBean[usersList.size()];
            int i = 0;
            while (i < usersList.size()) {
                users[i] = (UtentiBean)usersList.get(i);
                ++i;
            }
            results.close();
            this.stmt.close();
        }
        finally {
            this.shutdown();
        }
        return users;
    }

    public RuoloBean[] selectRoles() throws SQLException {
        this.createConnection();
        RuoloBean[] roles = null;
        RuoloBean role = null;
        ArrayList<RuoloBean> rolesList = new ArrayList<RuoloBean>();
        try {
            this.stmt = this.conn.createStatement();
            ResultSet results = this.stmt.executeQuery("select * from " + this.tableNameR);
            while (results.next()) {
                role = new RuoloBean();
                role.setRuolo(results.getString(1));
                role.setUtente(results.getString(2));
                role.setApplicazione(results.getString(3));
                rolesList.add(role);
            }
            roles = new RuoloBean[rolesList.size()];
            int i = 0;
            while (i < rolesList.size()) {
                roles[i] = (RuoloBean)rolesList.get(i);
                ++i;
            }
            results.close();
            this.stmt.close();
        }
        finally {
            this.shutdown();
        }
        return roles;
    }

    public RuoloBean[] getUserRoles(String utente) throws SQLException {
        this.createConnection();
        RuoloBean[] roles = null;
        RuoloBean role = null;
        ArrayList<RuoloBean> rolesList = new ArrayList<RuoloBean>();
        try {
            this.stmt = this.conn.createStatement();
            ResultSet results = this.stmt.executeQuery("select * from " + this.tableNameR + "," + this.tableNameU + " where UTENTE='" + utente + "'");
            while (results.next()) {
                role = new RuoloBean();
                role.setRuolo(results.getString(1));
                role.setUtente(results.getString(2));
                role.setApplicazione(results.getString(3));
                rolesList.add(role);
            }
            roles = new RuoloBean[rolesList.size()];
            int i = 0;
            while (i < rolesList.size()) {
                roles[i] = (RuoloBean)rolesList.get(i);
                ++i;
            }
            results.close();
            this.stmt.close();
        }
        finally {
            this.shutdown();
        }
        return roles;
    }

    public void insertUser(UtentiBean user) throws SQLException {
        this.createConnection();
        try {
            PreparedStatement stmt = this.conn.prepareStatement("INSERT INTO UTENTI VALUES ( ?, ?, ?, ?)");
            stmt.setString(1, user.getNome());
            stmt.setString(2, "");
            stmt.setString(3, user.getPath());
            stmt.setString(4, user.getPassword());
            stmt.executeUpdate();
            stmt.close();
            int i = 0;
            while (i < user.getRuoli().length) {
                this.insertRuolo(user.getRuoli()[i]);
                ++i;
            }
        }
        finally {
            this.shutdown();
        }
    }

    public void updateUser(String utente, UtentiBean user) throws SQLException {
        this.createConnection();
        try {
            PreparedStatement stmt = this.conn.prepareStatement("UPDATE UTENTI SET COD_FISC = ?, PATH = ?, PASSWORD = ? where NOME = '" + utente + "'");
            stmt.setString(1, "");
            stmt.setString(2, user.getPath());
            stmt.setString(3, user.getPassword());
            stmt.executeUpdate();
            stmt.close();
        }
        finally {
            this.shutdown();
        }
    }

    public void insertRuolo(RuoloBean ruoli) throws SQLException {
        this.createConnection();
        try {
            PreparedStatement stmt = this.conn.prepareStatement("INSERT INTO RUOLI VALUES ( ?, ?, ?)");
            stmt.setString(1, ruoli.getRuolo());
            stmt.setString(2, ruoli.getUtente());
            stmt.setString(3, ruoli.getApplicazione());
            stmt.executeUpdate();
            stmt.close();
        }
        finally {
            this.shutdown();
        }
    }

    public void cancellaUtente(String nome) throws SQLException {
        this.createConnection();
        String sql = "delete from UTENTI where NOME='" + nome + "'";
        try {
            this.stmt = this.conn.createStatement();
            this.stmt.execute(sql);
        }
        finally {
            this.shutdown();
        }
    }

    public void cancellaRuoliUtente(String nomeUtente) throws SQLException {
        this.createConnection();
        String sql = "delete from RUOLI where UTENTE='" + nomeUtente + "'";
        try {
            this.stmt = this.conn.createStatement();
            this.stmt.execute(sql);
        }
        finally {
            this.shutdown();
        }
    }

    public void cancellaGruppo(String nome) throws SQLException {
        this.createConnection();
        String sql = "delete from GRUPPI where NOME='" + nome + "'";
        try {
            this.stmt = this.conn.createStatement();
            this.stmt.execute(sql);
        }
        finally {
            this.shutdown();
        }
    }

    public void shutdown() throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
    }

    public boolean verificaUtente(String utente) throws SQLException {
        this.createConnection();
        boolean flag = false;
        try {
            this.stmt = this.conn.createStatement();
            ResultSet results = this.stmt.executeQuery("select NOME from UTENTI where NOME='" + utente + "'");
            while (results.next()) {
                results.getString(1);
                flag = true;
            }
            results.close();
            this.stmt.close();
        }
        finally {
            this.shutdown();
        }
        return flag;
    }

    public UtentiBean getUtente(String utente) throws SQLException {
        this.createConnection();
        UtentiBean user = null;
        try {
            this.stmt = this.conn.createStatement();
            ResultSet results = this.stmt.executeQuery("select * from UTENTI where NOME='" + utente + "'");
            if (results.next()) {
                user = new UtentiBean();
                user.setNome(results.getString(1));
                user.setPath(results.getString(3));
                user.setPassword(results.getString(4));
                user.setRuoli(this.getUserRoles(utente));
            }
            results.close();
            this.stmt.close();
        }
        finally {
            this.shutdown();
        }
        return user;
    }

    public UtentiBean getUtenteFromWS(String workspacePath) throws SQLException {
        this.createConnection();
        UtentiBean user = null;
        try {
            this.stmt = this.conn.createStatement();
            ResultSet results = this.stmt.executeQuery("select * from UTENTI where PATH='" + workspacePath + "'");
            if (results.next()) {
                user = new UtentiBean();
                user.setNome(results.getString(1));
                user.setPath(results.getString(3));
                user.setPassword(results.getString(4));
            }
            results.close();
            this.stmt.close();
        }
        finally {
            this.shutdown();
        }
        return user;
    }

    public String restituisciPath(String utente) throws SQLException {
        this.createConnection();
        String path = null;
        try {
            this.stmt = this.conn.createStatement();
            ResultSet results = this.stmt.executeQuery("select PATH from UTENTI where NOME='" + utente + "'");
            while (results.next()) {
                path = results.getString(1);
            }
            results.close();
            this.stmt.close();
        }
        finally {
            this.shutdown();
        }
        return path;
    }

    public boolean restituisciPassword(String utente, String password) throws SQLException {
        this.createConnection();
        boolean flag = false;
        try {
            this.stmt = this.conn.createStatement();
            ResultSet results = this.stmt.executeQuery("select * from UTENTI where NOME='" + utente + "' and PASSWORD='" + password + "'");
            while (results.next()) {
                flag = true;
            }
            results.close();
            this.stmt.close();
        }
        finally {
            this.shutdown();
        }
        return flag;
    }

    public static boolean dbExists() throws SQLException {
        DesktopDB desktopDb = new DesktopDB();
        boolean ret = false;
        ret = desktopDb.createConnection();
        desktopDb.shutdown();
        desktopDb.dbhandler.stopDB(desktopDb.dbname);
        return ret;
    }
}

