/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.parser;

import java.util.Properties;
import org.eclipse.help.internal.webapp.parser.ParseElement;
import org.eclipse.help.internal.webapp.parser.ResultParser;
import org.eclipse.help.internal.webapp.utils.JSonHelper;
import org.xml.sax.Attributes;

public class AboutParser
extends ResultParser {
    private ParseElement element = null;
    private String currentTag;
    private long service;

    public AboutParser(long service) {
        super("title");
        this.service = service;
        if (this.service == 3L) {
            this.setIdentifier("pluginId");
        }
    }

    public void startElement(String uri, String lname, String name, Attributes attrs) {
        this.currentTag = name;
        Properties properties = new Properties();
        properties.put("tagName", name);
        if ((this.service != 2L || !name.equalsIgnoreCase("preferences") && !name.equalsIgnoreCase("plugin")) && this.service != 3L) {
            properties.put("value", "");
        }
        int i = 0;
        while (i < attrs.getLength()) {
            String qname = attrs.getQName(i);
            String val = attrs.getValue(i);
            properties.put(qname, val);
            ++i;
        }
        ParseElement elem = new ParseElement(properties, this.element);
        if (this.element != null) {
            this.element.addChild(elem);
        } else {
            this.items.add(elem);
        }
        this.element = elem;
    }

    public void characters(char[] ch, int start, int length) {
        Properties properties;
        if (this.service == 2L && (this.currentTag.equalsIgnoreCase("preferences") || this.currentTag.equalsIgnoreCase("plugin")) || this.service == 3L) {
            return;
        }
        if (this.element != null && !this.currentTag.equals("") && (properties = this.element.getProps()) != null) {
            String content = new String(ch, start, length);
            String existing = (String)properties.get(this.currentTag);
            if (existing == null) {
                existing = "";
            }
            content = content.replaceAll("[\\n\\t]", "").trim();
            properties.put("value", String.valueOf(existing) + content);
            this.element.updateParseElement(properties);
        }
    }

    public void endElement(String uri, String lname, String name) {
        if (this.element != null) {
            this.element = this.element.getParent();
        }
        this.currentTag = "";
    }

    public String toJSON() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        buf.append("\n   ");
        buf.append("identifier");
        buf.append(":");
        buf.append(JSonHelper.getQuotes(this.id));
        buf.append(",");
        buf.append("\n   ");
        buf.append("label");
        buf.append(":");
        buf.append(JSonHelper.getQuotes(this.label));
        buf.append(",");
        ParseElement elem = (ParseElement)this.items.get(0);
        if (elem != null) {
            buf.append(elem.toJSON());
        }
        buf.append("}");
        return buf.toString();
    }
}

