/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.Cacheable;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.SequenceDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;
import org.apache.derby.impl.sql.catalog.SequenceGenerator;

public abstract class SequenceUpdater
implements Cacheable {
    protected DataDictionaryImpl _dd;
    protected String _uuidString;
    protected SequenceGenerator _sequenceGenerator;
    private long _lockTimeoutInMillis = this.getLockTimeout();

    public SequenceUpdater() {
    }

    public SequenceUpdater(DataDictionaryImpl dataDictionaryImpl) {
        this();
        this._dd = dataDictionaryImpl;
    }

    protected abstract SequenceGenerator createSequenceGenerator(TransactionController var1) throws StandardException;

    protected abstract boolean updateCurrentValueOnDisk(TransactionController var1, Long var2, Long var3, boolean var4) throws StandardException;

    public void clean(boolean bl) throws StandardException {
        if (this._sequenceGenerator != null) {
            this.updateCurrentValueOnDisk(null, this.peekAtCurrentValue());
        }
        this._uuidString = null;
        this._sequenceGenerator = null;
    }

    public boolean isDirty() {
        return false;
    }

    public Object getIdentity() {
        return this._uuidString;
    }

    public void clearIdentity() {
        try {
            this.clean(false);
        }
        catch (StandardException standardException) {
            SequenceUpdater.getLCC().getContextManager().cleanupOnError(standardException);
        }
    }

    public Cacheable createIdentity(Object object, Object object2) throws StandardException {
        SequenceUpdater sequenceUpdater = this;
        return sequenceUpdater.setIdentity(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cacheable setIdentity(Object object) throws StandardException {
        this._uuidString = (String)object;
        if (this._sequenceGenerator == null) {
            TransactionController transactionController = SequenceUpdater.getLCC().getTransactionExecute();
            TransactionController transactionController2 = transactionController.startNestedUserTransaction(true);
            try {
                this._sequenceGenerator = this.createSequenceGenerator(transactionController2);
            }
            finally {
                transactionController2.commit();
                transactionController2.destroy();
            }
        }
        if (this._sequenceGenerator != null) {
            return this;
        }
        return null;
    }

    public void getCurrentValueAndAdvance(NumberDataValue numberDataValue) throws StandardException {
        Long l = null;
        while (true) {
            long[] lArray = this._sequenceGenerator.getCurrentValueAndAdvance();
            int n = (int)lArray[0];
            long l2 = lArray[1];
            long l3 = lArray[2];
            long l4 = lArray[3];
            switch (n) {
                case 1: {
                    numberDataValue.setValue(l2);
                    return;
                }
                case 2: {
                    this.updateCurrentValueOnDisk(new Long(l2), null);
                    numberDataValue.setValue(l2);
                    return;
                }
                case 3: {
                    if (!this.updateCurrentValueOnDisk(new Long(l2), new Long(l3))) break;
                    this._sequenceGenerator.allocateNewRange(l2, l4);
                    break;
                }
                default: {
                    throw this.unimplementedFeature();
                }
            }
            if (l == null) {
                l = new Long(System.currentTimeMillis());
                continue;
            }
            if (this._lockTimeoutInMillis >= 0L && System.currentTimeMillis() - l > this._lockTimeoutInMillis) break;
        }
        throw StandardException.newException("X0Y84.S", this._sequenceGenerator.getName());
    }

    private Long peekAtCurrentValue() throws StandardException {
        return this._sequenceGenerator.peekAtCurrentValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCurrentValueOnDisk(Long l, Long l2) throws StandardException {
        TransactionController transactionController = SequenceUpdater.getLCC().getTransactionExecute();
        TransactionController transactionController2 = null;
        try {
            transactionController2 = transactionController.startNestedUserTransaction(false);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        if (transactionController2 != null) {
            try {
                boolean bl = this.updateCurrentValueOnDisk(transactionController2, l, l2, false);
                return bl;
            }
            catch (StandardException standardException) {
                if (!standardException.getMessageId().equals("40XL1")) {
                    throw standardException;
                }
            }
            finally {
                transactionController2.commit();
                transactionController2.destroy();
            }
        }
        return this.updateCurrentValueOnDisk(transactionController, l, l2, true);
    }

    protected int getLockTimeout() {
        return SequenceUpdater.getLCC().getTransactionExecute().getAccessManager().getLockFactory().getWaitTimeout();
    }

    private static LanguageConnectionContext getLCC() {
        return (LanguageConnectionContext)ContextService.getContextOrNull("LanguageConnectionContext");
    }

    private StandardException unimplementedFeature() {
        return StandardException.newException("XSCB3.S");
    }

    public static final class SyssequenceUpdater
    extends SequenceUpdater {
        private RowLocation _sequenceRowLocation;

        public SyssequenceUpdater() {
        }

        public SyssequenceUpdater(DataDictionaryImpl dataDictionaryImpl) {
            super(dataDictionaryImpl);
        }

        protected SequenceGenerator createSequenceGenerator(TransactionController transactionController) throws StandardException {
            RowLocation[] rowLocationArray = new RowLocation[1];
            SequenceDescriptor[] sequenceDescriptorArray = new SequenceDescriptor[1];
            this._dd.computeSequenceRowLocation(transactionController, this._uuidString, rowLocationArray, sequenceDescriptorArray);
            this._sequenceRowLocation = rowLocationArray[0];
            SequenceDescriptor sequenceDescriptor = sequenceDescriptorArray[0];
            return new SequenceGenerator(sequenceDescriptor.getCurrentValue(), sequenceDescriptor.canCycle(), sequenceDescriptor.getIncrement(), sequenceDescriptor.getMaximumValue(), sequenceDescriptor.getMinimumValue(), sequenceDescriptor.getStartValue(), sequenceDescriptor.getSequenceName());
        }

        protected boolean updateCurrentValueOnDisk(TransactionController transactionController, Long l, Long l2, boolean bl) throws StandardException {
            return this._dd.updateCurrentSequenceValue(transactionController, this._sequenceRowLocation, bl, l, l2);
        }
    }
}

