/*
 * Decompiled with CFR 0.152.
 */
package sogei.V9TJU000.utility;

import it.gov.agenziaentrate.specifichetecniche.telent.v1.ContenutoType;
import it.gov.agenziaentrate.specifichetecniche.telent.v1.IntestazioneType;
import it.gov.agenziaentrate.specifichetecniche.telent.v1.Messaggio;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;
import sogei.V9TJU000.utility.GestioneIntestazioneXML;

public class IntestazioneUtility
implements ValidationEventHandler {
    public GestioneIntestazioneXML getIntestazioneFromXSD(File file) {
        GestioneIntestazioneXML intestazione = null;
        Messaggio messaggio = null;
        StringBuffer message = new StringBuffer("");
        Unmarshaller unmarshaler = null;
        try {
            message.append("INIZIALIZZAZIONE... \n");
            JAXBContext jc = JAXBContext.newInstance((String)"it.gov.agenziaentrate.specifichetecniche.telent.v1");
            unmarshaler = jc.createUnmarshaller();
            File schemaFile = new File("common/telematico_v1.xsd");
            if (schemaFile.exists()) {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(schemaFile);
                unmarshaler.setSchema(schema);
                unmarshaler.setEventHandler((ValidationEventHandler)this);
            } else {
                System.out.println("Schema common/telematico_v1.xsd non trovato. Impossibile validare il documento XML");
            }
            message.append("ESEGUITA.");
            message.append("");
        }
        catch (JAXBException e) {
            this.logMessage((Exception)((Object)e));
        }
        catch (SAXException e) {
            this.logMessage(e);
        }
        try {
            messaggio = (Messaggio)unmarshaler.unmarshal(file);
            IntestazioneType intestazioneType = messaggio.getIntestazione();
            if (intestazioneType != null) {
                intestazione = new GestioneIntestazioneXML();
                intestazione.setSpazioServizioTelematico(intestazioneType.getSpazioServizioTelematico());
                intestazione.setCodiceFiscaleFornitore(intestazioneType.getCodiceFiscaleFornitore());
                ContenutoType contenutoType = messaggio.getContenuto();
                if (contenutoType != null) {
                    intestazione.setCodiceFornitura(contenutoType.getCodiceFornitura());
                }
            } else {
                message.append("CodiceFornitura:          " + intestazione + "\n");
            }
        }
        catch (JAXBException e) {
            this.logMessage("\tFile: " + file.getName() + "\n" + e.getMessage() + "\n\n");
            return null;
        }
        message.append("\n");
        this.logMessage(message.toString());
        return intestazione;
    }

    public boolean handleEvent(ValidationEvent event) {
        boolean retVal;
        boolean bl = retVal = event.getMessage() != null && event.getMessage().indexOf("Fornitura") >= 0;
        if (!retVal) {
            this.logMessage("VALIDATION ERROR: " + event.getMessage());
        }
        return retVal;
    }

    private void logMessage(Exception e) {
        this.logMessage("************** ERROR 4: " + e.getMessage());
    }

    private void logMessage(Throwable e) {
        this.logMessage("************** ERROR 5: " + e.getMessage());
    }

    private void logMessage(String message) {
        System.out.println(message);
    }
}

