/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.transform;

import iaik.xml.crypto.alg.transform.TransformServiceImpl;
import iaik.xml.crypto.dom.DOMNodeSetData;
import iaik.xml.crypto.dsig.spec.XPathParameterImpl;
import iaik.xml.filter.impl.dsig.XPathException;
import iaik.xml.filter.impl.dsig.XPathSieve;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import org.w3c.dom.Node;

public class XPathTransformService
extends TransformServiceImpl {
    XPathParameterImpl param_;
    XPathFilterParameterSpec spec_;

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        XPathSieve xPathSieve;
        Iterator iterator;
        if (data instanceof OctetStreamData) {
            iterator = this.parse((OctetStreamData)data);
        } else if (data instanceof NodeSetData) {
            iterator = ((NodeSetData)data).iterator();
        } else {
            throw new ClassCastException("The data type is not compatible with this " + this.getClass().getName() + ".");
        }
        Node node = this.param_ != null ? this.param_.getNode() : null;
        try {
            xPathSieve = new XPathSieve(iterator, this.spec_.getXPath(), node, this.spec_.getNamespaceMap(), (DOMCryptoContext)xMLCryptoContext);
        }
        catch (XPathException xPathException) {
            throw new TransformException(xPathException);
        }
        return new DOMNodeSetData(xPathSieve);
    }

    protected void setParameterSpec(List list) throws InvalidAlgorithmParameterException {
        if (list.size() != 1 || !(list.get(0) instanceof XPathParameterImpl)) {
            if (list.size() != 0) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameters not supported by CanonicalizationMethod " + this.getAlgorithm() + ".");
            }
            throw new InvalidAlgorithmParameterException("Transform " + this.getAlgorithm() + " requires parameters.");
        }
        this.param_ = (XPathParameterImpl)list.get(0);
        this.spec_ = new XPathFilterParameterSpec(this.param_.getXpath());
    }

    protected void setParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("Transform " + this.getAlgorithm() + " requires parameters.");
        }
        this.spec_ = (XPathFilterParameterSpec)algorithmParameterSpec;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.spec_;
    }

    public List getAlgorithmParameters() {
        if (this.param_ == null) {
            this.param_ = new XPathParameterImpl(this.spec_.getXPath(), this.spec_.getNamespaceMap());
        }
        ArrayList<XPathParameterImpl> arrayList = new ArrayList<XPathParameterImpl>(1);
        arrayList.add(this.param_);
        return arrayList;
    }
}

