/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dom.XencDOMStructure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.CipherValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CipherValueImpl
extends XencDOMStructure
implements CipherValue {
    byte[] value_ = null;

    protected void unmarshalElement(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.unmarshalElement(dOMCryptoContext, element);
        this.value_ = DOMStructure.getBytesFromElement(element);
    }

    public void setValue(byte[] byArray) {
        this.value_ = byArray;
    }

    protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element = super.marshalElement(dOMCryptoContext, node, node2);
        if (this.value_ != null) {
            DOMStructure.addBytesToElement(element, this.value_, dOMCryptoContext);
        }
        return element;
    }

    public InputStream getValueStream() {
        return this.value_ != null ? new ByteArrayInputStream(this.value_) : null;
    }

    public byte[] getValue() {
        return this.value_ != null ? (byte[])this.value_.clone() : null;
    }

    public String getLocalName() {
        return "CipherValue";
    }

    public void appendValue(DOMCryptoContext dOMCryptoContext, byte[] byArray) throws MarshalException {
        if (this.state_ < 1) {
            throw new MarshalException("Element hasn't been marshaled yet.");
        }
        if (this.value_ != null) {
            throw new MarshalException("Digest value has already been appended.");
        }
        this.value_ = byArray;
        DOMStructure.addBytesToElement((Element)this.getNode(), byArray, dOMCryptoContext);
    }

    public CipherValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.value_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public CipherValueImpl(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("Argument 'cipherValueStream' must not be null.");
        }
        byte[] byArray = new byte[1024];
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        this.value_ = byteArrayOutputStream.toByteArray();
    }

    public CipherValueImpl() {
    }
}

