/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.utils;

import iaik.xml.crypto.dom.DOMNodeSetData;
import iaik.xml.filter.impl.CachedInputStream;
import iaik.xml.filter.impl.CachedIterator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import org.w3c.dom.Node;

public class CachedData {
    CachedIterator cit_;
    CachedInputStream cis_;
    Data output_;

    public Data getOutput() {
        return this.output_;
    }

    public Data getCachedData() {
        if (this.cis_ != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.cis_.getCachedBytes());
            return new OctetStreamData(byteArrayInputStream);
        }
        if (this.cit_ != null) {
            List list = this.cit_.getCachedObjects();
            return new DOMNodeSetData(list.iterator());
        }
        return null;
    }

    public static final Data debugOutput(Data data, OutputStream outputStream) {
        Data data2;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
        try {
            if (data instanceof OctetStreamData) {
                outputStreamWriter.write(">>>>>>>>>>>>>>>>>>>>>>>>>>>> OctetStreamData <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
                outputStreamWriter.flush();
                InputStream inputStream = ((OctetStreamData)data).getOctetStream();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[512];
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                outputStream.flush();
                data2 = new OctetStreamData(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            } else {
                outputStreamWriter.write(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> NodeSetData <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n");
                outputStreamWriter.flush();
                Iterator iterator = ((NodeSetData)data).iterator();
                ArrayList<Node> arrayList = new ArrayList<Node>();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    outputStreamWriter.write(String.valueOf(node.toString()) + "\n");
                    arrayList.add(node);
                }
                data2 = new DOMNodeSetData(arrayList.iterator());
            }
            outputStreamWriter.write("\n^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^\n");
            outputStreamWriter.flush();
        }
        catch (IOException iOException) {
            System.err.println("Failed to write to debug output stream. " + iOException.getMessage());
            data2 = data;
        }
        return data2;
    }

    public CachedData(Data data) {
        if (data instanceof OctetStreamData) {
            this.cis_ = new CachedInputStream(((OctetStreamData)data).getOctetStream());
            this.output_ = new OctetStreamData(this.cis_);
        } else if (data instanceof NodeSetData) {
            this.cit_ = new CachedIterator(((NodeSetData)data).iterator());
            this.output_ = new DOMNodeSetData(this.cit_);
        } else {
            this.output_ = data;
        }
    }
}

