/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.utils;

import iaik.xml.crypto.dom.DOMNodeSetData;
import iaik.xml.crypto.utils.DOMUtils;
import iaik.xml.crypto.utils.Nodes;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import iaik.xml.filter.impl.dsig.SequenceTraverser;
import iaik.xml.filter.impl.dsig.Traverser;
import iaik.xml.filter.impl.dsig.XPathEvaluator;
import iaik.xml.filter.impl.dsig.XPathException;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMURIReference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class URIDereferencerImpl
implements URIDereferencer {
    static /* synthetic */ Class class$javax$xml$crypto$URIDereferencer;
    private static final String XMLNS_OPENER_ = "xmlns(";
    private static final String XPOINTER_OPENER_ = "xpointer(";

    private static Hashtable parseXmlNSDeclarations(String string) throws URIReferenceException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>(4);
        int n = 0;
        while ((n = string.indexOf(XMLNS_OPENER_, n)) >= 0) {
            int n2 = n + XMLNS_OPENER_.length();
            String string2 = string.substring(n2, (n = URIDereferencerImpl.findClosingBrace(string, n2) + 1) - 1);
            int n3 = string2.indexOf(61);
            if (n3 == -1) {
                throw new URIReferenceException("Cannot find equals sign '=' in xmlns XPointer part '" + string2 + "'.");
            }
            String string3 = string2.substring(0, n3);
            String string4 = string2.substring(n3 + 1, string2.length());
            hashtable.put(string3, string4);
        }
        return hashtable;
    }

    private static Vector parseXPointers(String string) throws URIReferenceException {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while ((n = string.indexOf(XPOINTER_OPENER_, n)) >= 0) {
            int n2 = n + XPOINTER_OPENER_.length();
            n = URIDereferencerImpl.findClosingBrace(string, n2) + 1;
            String string2 = string.substring(n2, n - 1);
            vector.add(string2);
        }
        return vector;
    }

    private String makePrefixString(Hashtable hashtable) {
        Iterator iterator = hashtable.keySet().iterator();
        StringWriter stringWriter = new StringWriter();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.equals("xmlns")) continue;
            stringWriter.write(string.substring(6));
            stringWriter.write(" " + (String)hashtable.get(string) + " ");
        }
        return stringWriter.toString();
    }

    public static boolean isSameDocumentFullXPointer(String string) throws URIReferenceException {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URIException uRIException) {
            throw new URIReferenceException("URI '" + string + "' is not RFC 2396 compliant.", uRIException);
        }
        return URIDereferencerImpl.isFullXPointer(uRI.getReferenceUnescaped());
    }

    private static boolean isFullXPointer(String string) {
        return string.startsWith(XPOINTER_OPENER_) || string.startsWith(XMLNS_OPENER_);
    }

    private static int findClosingBrace(String string, int n) throws URIReferenceException {
        int n2 = 0;
        int n3 = 1;
        char[] cArray = string.substring(n).toCharArray();
        while (n2 < cArray.length && n3 > 0) {
            switch (cArray[n2]) {
                case '(': {
                    int n4 = 0;
                    while (string.charAt(n + n2 - n4 - 1) == '^') {
                        ++n4;
                    }
                    if (n4 % 2 != 0) break;
                    ++n3;
                    break;
                }
                case ')': {
                    int n4 = 0;
                    while (string.charAt(n + n2 - n4 - 1) == '^') {
                        ++n4;
                    }
                    if (n4 % 2 != 0) break;
                    --n3;
                    break;
                }
            }
            ++n2;
        }
        if (n3 == 0) {
            return n2 + n - 1;
        }
        throw new URIReferenceException("Cannot find closing brace in URI reference XPointer '" + string + "'.");
    }

    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        Object object;
        URI uRI;
        if (uRIReference == null) {
            throw new NullPointerException("Argument 'uriReference' can not be null.");
        }
        if (xMLCryptoContext == null) {
            throw new NullPointerException("Argument 'context' can not be null.");
        }
        if (!(uRIReference instanceof DOMURIReference) || !(xMLCryptoContext instanceof DOMCryptoContext)) {
            throw new IllegalArgumentException("This " + (class$javax$xml$crypto$URIDereferencer != null ? class$javax$xml$crypto$URIDereferencer : (class$javax$xml$crypto$URIDereferencer = URIDereferencerImpl.class$("javax.xml.crypto.URIDereferencer"))).getName() + " implementation supports the DOM XML mechanism only.");
        }
        String string = uRIReference.getURI();
        if (string == null) {
            throw new URIReferenceException("Cannot resolve a URI of value 'null'.");
        }
        try {
            uRI = new URI(string);
        }
        catch (URIException uRIException) {
            throw new URIReferenceException("URI '" + uRIReference.getURI() + "' is not RFC 2396 compliant.", uRIException);
        }
        if (uRI.isEmpty() || uRI.isReference()) {
            Object object2;
            Node node = ((DOMURIReference)uRIReference).getHere();
            Document document = node != null ? DOMUtils.getOwnerDocument(node) : DOMUtils.getDocFromDOMCryptoContext((DOMCryptoContext)xMLCryptoContext);
            if (document == null) {
                throw new URIReferenceException("URI '" + uRIReference.getURI() + "' is reference only, but neither the uriReference nor the context " + "contain a node to get the corresponding document from.");
            }
            if (uRI.isEmpty()) {
                Traverser traverser = new Traverser(document, false, true);
                return new DOMNodeSetData(traverser);
            }
            String string2 = uRI.getReferenceUnescaped();
            if (!URIDereferencerImpl.isFullXPointer(string2)) {
                DOMCryptoContext dOMCryptoContext = (DOMCryptoContext)xMLCryptoContext;
                Element element = dOMCryptoContext.getElementById(string2);
                if (element == null && (element = document.getElementById(string2)) == null) {
                    throw new URIReferenceException("Sub-resource error resolving shorthand xpointer, id '" + string2 + "' is not registered.");
                }
                Traverser traverser = new Traverser(element, false, true);
                return new DOMNodeSetData(traverser);
            }
            Hashtable hashtable = URIDereferencerImpl.parseXmlNSDeclarations(string2);
            Vector vector = URIDereferencerImpl.parseXPointers(string2);
            Enumeration enumeration = vector.elements();
            Iterator iterator = Nodes.EMPTY_ITERATOR;
            while (!iterator.hasNext() && enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                if ("/".equals(object2)) {
                    return new DOMNodeSetData(new Traverser(document, true, true));
                }
                try {
                    XPathEvaluator xPathEvaluator = XPathEvaluator.newXPathEvaluator((String)object2, node, hashtable, (DOMCryptoContext)xMLCryptoContext);
                    iterator = xPathEvaluator.evaluate(document);
                }
                catch (XPathException xPathException) {
                    throw new URIReferenceException("Cannot evaluate URI reference XPointer '" + (String)object2 + "'." + xPathException.getMessage(), xPathException);
                }
            }
            object2 = new SequenceTraverser(iterator, true, true);
            return new DOMNodeSetData((Iterator)object2);
        }
        if (!uRI.isAbsolute()) {
            if (xMLCryptoContext.getBaseURI() == null) {
                throw new URIReferenceException("Failed to absolutize URI '" + uRI.toString() + "', base URI given in context is null.");
            }
            try {
                object = new URI(xMLCryptoContext.getBaseURI());
            }
            catch (URIException uRIException) {
                throw new URIReferenceException("Failed to absolutize URI '" + uRI.toString() + "', base URI '" + xMLCryptoContext.getBaseURI() + "' given in context is not RFC 2396 compliant.", uRIException);
            }
            if (!((URI)object).isAbsolute()) {
                throw new URIReferenceException("Failed to absolutize URI '" + uRI.toString() + "', base URI '" + xMLCryptoContext.getBaseURI() + "' given in context is not absolute according to RFC 2396.");
            }
            try {
                uRI = URI.absolutizeURI((URI)object, uRI);
            }
            catch (URIException uRIException) {
                throw new URIReferenceException("Failed to absolutize URI '" + uRI.toString() + "' with base URI '" + xMLCryptoContext.getBaseURI() + "' given in context.", uRIException);
            }
        }
        object = null;
        try {
            object = new URL(uRI.toString());
            URLConnection uRLConnection = ((URL)object).openConnection();
            return new OctetStreamData(uRLConnection.getInputStream(), uRI.toString(), uRLConnection.getContentType());
        }
        catch (MalformedURLException malformedURLException) {
            throw new URIReferenceException("URI '" + uRI.toString() + "' cannot be resolved. URL: " + object, malformedURLException);
        }
        catch (IOException iOException) {
            try {
                if (System.getProperty("java.version").startsWith("1.2.2")) {
                    object = new URL(uRI.toUnescapedString());
                    URLConnection uRLConnection = ((URL)object).openConnection();
                    return new OctetStreamData(uRLConnection.getInputStream(), uRI.toString(), uRLConnection.getContentType());
                }
                object = new URL(((URL)object).toExternalForm());
                URLConnection uRLConnection = ((URL)object).openConnection();
                return new OctetStreamData(uRLConnection.getInputStream(), uRI.toString(), uRLConnection.getContentType());
            }
            catch (MalformedURLException malformedURLException) {
                throw new URIReferenceException("URI '" + uRI.toString() + "' cannot be resolved. URL: " + object, malformedURLException);
            }
            catch (IOException iOException2) {
                throw new URIReferenceException("URI '" + uRI.toString() + "' cannot be resolved. URL: " + object, iOException2);
            }
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

