/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.awt.AWTAccessor;
import sun.awt.GlobalCursorManager;
import sun.awt.SunToolkit;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

public final class XGlobalCursorManager
extends GlobalCursorManager {
    private static Field field_pData;
    private static Field field_type;
    private static Class cursorClass;
    private static Method method_setPData;
    private WeakReference<Component> nativeContainer;
    private static XGlobalCursorManager manager;

    static GlobalCursorManager getCursorManager() {
        if (manager == null) {
            manager = new XGlobalCursorManager();
        }
        return manager;
    }

    static void nativeUpdateCursor(Component component) {
        XGlobalCursorManager.getCursorManager().updateCursorLater(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setCursor(Component component, Cursor cursor, boolean bl) {
        Object object;
        if (component == null) {
            return;
        }
        Cursor cursor2 = bl ? cursor : this.getCapableCursor(component);
        Component component2 = null;
        if (bl) {
            object = this;
            synchronized (object) {
                component2 = (Component)this.nativeContainer.get();
            }
        } else {
            component2 = SunToolkit.getHeavyweightComponent(component);
        }
        if (component2 != null && (object = AWTAccessor.getComponentAccessor().getPeer(component2)) instanceof XComponentPeer) {
            XGlobalCursorManager xGlobalCursorManager = this;
            synchronized (xGlobalCursorManager) {
                this.nativeContainer = new WeakReference<Component>(component2);
            }
            ((XComponentPeer)object).pSetCursor(cursor2, false);
            XGlobalCursorManager.updateGrabbedCursor(cursor2);
        }
    }

    private static void updateGrabbedCursor(Cursor cursor) {
        XBaseWindow xBaseWindow = XAwtState.getGrabWindow();
        if (xBaseWindow instanceof XWindowPeer) {
            XWindowPeer xWindowPeer = (XWindowPeer)xBaseWindow;
            xWindowPeer.pSetCursor(cursor);
        }
    }

    @Override
    protected void updateCursorOutOfJava() {
        XGlobalCursorManager.updateGrabbedCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getCursorPos(Point point) {
        if (!((XToolkit)Toolkit.getDefaultToolkit()).getLastCursorPos(point)) {
            XToolkit.awtLock();
            try {
                long l = XToolkit.getDisplay();
                long l2 = XlibWrapper.RootWindow(l, XlibWrapper.DefaultScreen(l));
                XlibWrapper.XQueryPointer(l, l2, XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
                point.x = XlibWrapper.unsafe.getInt(XlibWrapper.larg3);
                point.y = XlibWrapper.unsafe.getInt(XlibWrapper.larg4);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    protected Component findHeavyweightUnderCursor() {
        return XAwtState.getComponentMouseEntered();
    }

    @Override
    protected Component findComponentAt(Container container, int n, int n2) {
        return container.findComponentAt(n, n2);
    }

    @Override
    protected Point getLocationOnScreen(Component component) {
        return component.getLocationOnScreen();
    }

    @Override
    protected Component findHeavyweightUnderCursor(boolean bl) {
        return this.findHeavyweightUnderCursor();
    }

    private Cursor getCapableCursor(Component component) {
        AWTAccessor.ComponentAccessor componentAccessor = AWTAccessor.getComponentAccessor();
        Component component2 = component;
        while (component2 != null && !(component2 instanceof Window) && componentAccessor.isEnabled(component2) && componentAccessor.isVisible(component2) && componentAccessor.isDisplayable(component2)) {
            component2 = componentAccessor.getParent(component2);
        }
        if (component2 instanceof Window) {
            return componentAccessor.isEnabled(component2) && componentAccessor.isVisible(component2) && componentAccessor.isDisplayable(component2) && componentAccessor.isEnabled(component) ? componentAccessor.getCursor(component) : Cursor.getPredefinedCursor(0);
        }
        if (component2 == null) {
            return null;
        }
        return this.getCapableCursor(componentAccessor.getParent(component2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getCursor(Cursor cursor) {
        long l = 0L;
        int n = 0;
        try {
            l = field_pData.getLong(cursor);
            n = field_type.getInt(cursor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (l != 0L) {
            return l;
        }
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 68;
                break;
            }
            case 1: {
                n2 = 34;
                break;
            }
            case 2: {
                n2 = 152;
                break;
            }
            case 3: {
                n2 = 150;
                break;
            }
            case 4: {
                n2 = 12;
                break;
            }
            case 6: {
                n2 = 134;
                break;
            }
            case 5: {
                n2 = 14;
                break;
            }
            case 7: {
                n2 = 136;
                break;
            }
            case 9: {
                n2 = 16;
                break;
            }
            case 8: {
                n2 = 138;
                break;
            }
            case 10: {
                n2 = 70;
                break;
            }
            case 11: {
                n2 = 96;
                break;
            }
            case 12: {
                n2 = 60;
                break;
            }
            case 13: {
                n2 = 52;
            }
        }
        XToolkit.awtLock();
        try {
            l = XlibWrapper.XCreateFontCursor(XToolkit.getDisplay(), n2);
        }
        finally {
            XToolkit.awtUnlock();
        }
        XGlobalCursorManager.setPData(cursor, l);
        return l;
    }

    static void setPData(Cursor cursor, long l) {
        try {
            method_setPData.invoke(cursor, l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        cursorClass = Cursor.class;
        field_pData = SunToolkit.getField(cursorClass, "pData");
        field_type = SunToolkit.getField(cursorClass, "type");
        method_setPData = SunToolkit.getMethod(cursorClass, "setPData", new Class[]{Long.TYPE});
        if (field_pData == null || field_type == null || method_setPData == null) {
            System.out.println("Unable to initialize XGlobalCursorManager: ");
            Thread.dumpStack();
        }
    }
}

