/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.EnvelopedDataStream;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import javax.crypto.SecretKey;

public class EnvelopedData
extends EnvelopedDataStream
implements Content {
    static /* synthetic */ Class b;
    private EncryptedContentInfo a;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        if (bl) {
            int n2 = 0;
            while (n2 < this.recipient_infos.size()) {
                stringBuffer.append("\nRecipientInfo " + (n2 + 1) + ":{\n");
                stringBuffer.append(((RecipientInfo)this.recipient_infos.elementAt(n2)).toString());
                stringBuffer.append("\n}");
                ++n2;
            }
        } else {
            stringBuffer.append("RecipientInfos: " + this.recipient_infos.size() + "\n");
        }
        stringBuffer.append("\nEncryptedContentInfo: {\n");
        stringBuffer.append(String.valueOf(this.a.toString()) + "}");
        return stringBuffer.toString();
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        Object object;
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        if (this.recipient_infos == null) {
            throw new PKCSException("No recipients specified.");
        }
        if (this.symmetric_key != null) {
            object = this.recipient_infos.elements();
            while (object.hasMoreElements()) {
                ((RecipientInfo)object.nextElement()).encryptKey(this.symmetric_key);
            }
        }
        this.a.setBlockSize(n2);
        object = new SEQUENCE(n2 > 0);
        try {
            ((ConstructedType)object).addComponent(new INTEGER(this.version));
            if (this.version == 1) {
                ((ConstructedType)object).addComponent(ASN.createSequenceOf(this.recipient_infos));
            } else {
                ((ConstructedType)object).addComponent(ASN.createSetOf(this.recipient_infos));
            }
            ((ConstructedType)object).addComponent(this.a.toASN1Object());
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        return object;
    }

    public void setupCipher(PrivateKey privateKey, int n2) throws InvalidKeyException, NoSuchAlgorithmException, PKCSException {
        RecipientInfo recipientInfo = (RecipientInfo)this.recipient_infos.elementAt(n2);
        SecretKey secretKey = recipientInfo.decryptKey(privateKey, this.a.getContentEncryptionAlgorithm().getRawImplementationName());
        this.a.setupCipher(secretKey);
    }

    public void setupCipher(Key key) throws InvalidKeyException, NoSuchAlgorithmException, PKCSException {
        this.a.setupCipher(key);
    }

    public InputStream getInputStream() {
        return this.a.getInputStream();
    }

    public Object getEncryptedContentInfo() {
        return this.a;
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public byte[] getContent() {
        return this.a.getContent();
    }

    public void decode(InputStream inputStream) throws PKCSParsingException, IOException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = ((DerInputStream)inputStream).readSequence();
        this.version = derInputStream.readInteger().intValue();
        try {
            this.recipient_infos = Util.getVector((RecipientInfo[])ASN.parseSequenceOf(DerCoder.decode(derInputStream), b != null ? b : (b = EnvelopedData.a("iaik.pkcs.pkcs7.RecipientInfo"))));
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException("Error parsing recipient infos!");
        }
        this.a = new EncryptedContentInfo();
        this.a.a = this.version;
        this.a.decode(derInputStream);
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode(aSN1Object)));
            return;
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public EnvelopedData(RecipientInfo[] recipientInfoArray, EncryptedContentInfo encryptedContentInfo, int n2) {
        this();
        this.recipient_infos = Util.getVector(recipientInfoArray);
        this.a = encryptedContentInfo;
        if (n2 == 1) {
            this.version = 1;
            this.a.a = 1;
            return;
        }
        if (n2 != 0) {
            throw new IllegalArgumentException("Invalid version number: " + n2);
        }
    }

    public EnvelopedData(RecipientInfo[] recipientInfoArray, EncryptedContentInfo encryptedContentInfo) {
        this();
        this.recipient_infos = Util.getVector(recipientInfoArray);
        this.a = encryptedContentInfo;
    }

    public EnvelopedData(byte[] byArray, AlgorithmID algorithmID, int n2, int n3) throws NoSuchAlgorithmException {
        this();
        this.a = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
        if (n3 == 1) {
            this.version = 1;
            this.a.a = 1;
        } else if (n3 != 0) {
            throw new IllegalArgumentException("Invalid version number: " + n3);
        }
        this.symmetric_key = this.a.setupCipher(algorithmID, n2);
    }

    public EnvelopedData(byte[] byArray, AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        this();
        this.a = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
        this.symmetric_key = this.a.setupCipher(algorithmID, n2);
    }

    public EnvelopedData(byte[] byArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this();
        this.a = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
        this.symmetric_key = this.a.setupCipher(algorithmID);
    }

    public EnvelopedData(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    public EnvelopedData(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    protected EnvelopedData() {
        this.block_size = -1;
    }
}

