/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.dsig.AlgorithmMethodImpl;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.w3c.dom.Node;

public class SignatureMethodImpl
extends AlgorithmMethodImpl
implements SignatureMethod {
    static /* synthetic */ Class class$javax$xml$crypto$dsig$spec$SignatureMethodParameterSpec;
    protected Mac mac_;
    protected Signature signature_;
    private static final URI XMLDSIG_MORE_NS;
    private static URI xml_dsig_more_ns;
    private static final URI XMLDSIG_NS;
    private static URI xml_dsig_ns;

    public boolean validateSignatureValue(Key key, byte[] byArray, InputStream inputStream) throws IOException, XMLSignatureException {
        int n;
        if (this.signature_ != null) {
            block11: {
                try {
                    if (key instanceof PublicKey) {
                        this.signature_.initVerify((PublicKey)key);
                        break block11;
                    }
                    throw new InvalidKeyException("Key '" + key + "' is not a valid public key.");
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new XMLSignatureException(invalidKeyException);
                }
            }
            try {
                int n2;
                byte[] byArray2 = new byte[1024];
                while ((n2 = inputStream.read(byArray2)) != -1) {
                    this.signature_.update(byArray2, 0, n2);
                }
                return this.signature_.verify(byArray);
            }
            catch (SignatureException signatureException) {
                throw new XMLSignatureException(signatureException);
            }
        }
        try {
            this.mac_.init(key, this.spec_);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException(invalidAlgorithmParameterException);
        }
        byte[] byArray3 = new byte[1024];
        while ((n = inputStream.read(byArray3)) != -1) {
            this.mac_.update(byArray3, 0, n);
        }
        byArray3 = this.mac_.doFinal();
        this.mac_.reset();
        return Arrays.equals(byArray3, byArray);
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public String getLocalName() {
        return "SignatureMethod";
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public byte[] calculateSignatureValue(Key key, InputStream inputStream) throws IOException, XMLSignatureException {
        int n;
        if (this.signature_ != null) {
            block11: {
                try {
                    if (key instanceof PrivateKey) {
                        this.signature_.initSign((PrivateKey)key);
                        break block11;
                    }
                    throw new InvalidKeyException("Key '" + key + "' is not a valid private key.");
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new XMLSignatureException(invalidKeyException);
                }
            }
            try {
                int n2;
                byte[] byArray = new byte[1024];
                while ((n2 = inputStream.read(byArray)) != -1) {
                    this.signature_.update(byArray, 0, n2);
                }
                return this.signature_.sign();
            }
            catch (SignatureException signatureException) {
                throw new XMLSignatureException(signatureException);
            }
        }
        try {
            this.mac_.init(key, this.spec_);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException(invalidAlgorithmParameterException);
        }
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            this.mac_.update(byArray, 0, n);
        }
        byArray = this.mac_.doFinal();
        this.mac_.reset();
        return byArray;
    }

    public SignatureMethodImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null.");
        }
        this.unmarshal(dOMCryptoContext);
        try {
            try {
                this.mac_ = Mac.getInstance(this.algorithm_.toString());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.signature_ = Signature.getInstance(this.algorithm_.toString());
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException(noSuchAlgorithmException);
        }
        if (this.params_ != null) {
            try {
                this.spec_ = this.params_.getParameterSpec(class$javax$xml$crypto$dsig$spec$SignatureMethodParameterSpec != null ? class$javax$xml$crypto$dsig$spec$SignatureMethodParameterSpec : (class$javax$xml$crypto$dsig$spec$SignatureMethodParameterSpec = SignatureMethodImpl.class$("javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec")));
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new MarshalException(invalidParameterSpecException);
            }
        }
    }

    public SignatureMethodImpl(String string, SignatureMethodParameterSpec signatureMethodParameterSpec) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        super(string, signatureMethodParameterSpec);
        try {
            if (!this.algorithm_.equals(new URI(String.valueOf(String.valueOf(XMLDSIG_NS)) + "#" + this.algorithm_.getReference())) && !this.algorithm_.equals(new URI(String.valueOf(String.valueOf(XMLDSIG_MORE_NS)) + "#" + this.algorithm_.getReference()))) {
                throw new NoSuchAlgorithmException("Algorithm " + this.algorithm_ + " not in namespace. " + new URI(String.valueOf(String.valueOf(XMLDSIG_NS)) + "#" + this.algorithm_.getReference()));
            }
        }
        catch (URIException uRIException) {
            throw new NoSuchAlgorithmException("Algorithm URI '" + string + "' is not RFC 2396 compliant.");
        }
        try {
            this.mac_ = Mac.getInstance(this.algorithm_.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                this.signature_ = Signature.getInstance(this.algorithm_.toString());
                if (this.spec_ != null) {
                    this.signature_.setParameter(this.spec_);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new NoSuchAlgorithmException(String.valueOf(this.algorithm_.toString()) + " identifies neither a MAC nor a Signature. " + noSuchAlgorithmException.getMessage() + noSuchAlgorithmException2.getMessage());
            }
        }
    }

    static {
        xml_dsig_ns = null;
        try {
            xml_dsig_ns = new URI("http://www.w3.org/2000/09/xmldsig");
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
        XMLDSIG_NS = xml_dsig_ns;
        xml_dsig_more_ns = null;
        try {
            xml_dsig_more_ns = new URI("http://www.w3.org/2001/04/xmldsig-more");
        }
        catch (URIException uRIException) {
            uRIException.printStackTrace();
        }
        XMLDSIG_MORE_NS = xml_dsig_more_ns;
    }
}

