/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig.keyinfo;

import iaik.xsect.com.fourthpass.a;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.KeyException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.List;
import java.util.Properties;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NoSuchMechanismException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;

public abstract class KeyInfoFactory {
    private String mechanismType;
    private Provider provider;
    private static final String TYPE = "KeyInfoFactory";

    public abstract KeyInfo unmarshalKeyInfo(XMLStructure var1) throws MarshalException;

    public abstract X509IssuerSerial newX509IssuerSerial(String var1, BigInteger var2);

    public abstract X509Data newX509Data(List var1);

    public abstract RetrievalMethod newRetrievalMethod(String var1, String var2, List var3);

    public abstract RetrievalMethod newRetrievalMethod(String var1);

    public abstract PGPData newPGPData(byte[] var1, byte[] var2, List var3);

    public abstract PGPData newPGPData(byte[] var1, List var2);

    public abstract PGPData newPGPData(byte[] var1);

    public abstract KeyValue newKeyValue(PublicKey var1) throws KeyException;

    public abstract KeyName newKeyName(String var1);

    public abstract KeyInfo newKeyInfo(List var1, String var2);

    public abstract KeyInfo newKeyInfo(List var1);

    public abstract boolean isFeatureSupported(String var1);

    public abstract URIDereferencer getURIDereferencer();

    public final Provider getProvider() {
        return this.provider;
    }

    public final String getMechanismType() {
        return this.mechanismType;
    }

    public static KeyInfoFactory getInstance(String string, Provider provider) {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (provider == null) {
            throw new NullPointerException("provider cannot be null");
        }
        try {
            return KeyInfoFactory.findInstance(string, provider);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLSignatureException);
        }
    }

    public static KeyInfoFactory getInstance(String string, String string2) throws NoSuchProviderException {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        if (string2 == null) {
            throw new NullPointerException("provider cannot be null");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException("cannot find provider named " + string2);
        }
        try {
            return KeyInfoFactory.findInstance(string, provider);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLSignatureException);
        }
    }

    public static KeyInfoFactory getInstance(String string) {
        if (string == null) {
            throw new NullPointerException("mechanismType cannot be null");
        }
        try {
            return KeyInfoFactory.findInstance(string, null);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.", xMLSignatureException);
        }
    }

    public static KeyInfoFactory getInstance() {
        return KeyInfoFactory.getInstance("DOM");
    }

    private static KeyInfoFactory findInstance(String string, Provider serializable) throws XMLSignatureException {
        Object object;
        Object object2;
        Serializable serializable2;
        Provider[] providerArray;
        String string2 = null;
        if (serializable != null) {
            Provider[] providerArray2 = new Provider[1];
            providerArray = providerArray2;
            providerArray2[0] = serializable;
        } else {
            providerArray = Security.getProviders();
        }
        Provider[] providerArray3 = providerArray;
        int n = 0;
        while (n < providerArray3.length) {
            serializable2 = providerArray3[n];
            object2 = ((Properties)serializable2).getProperty("Alg.Alias.KeyInfoFactory." + string);
            object = "KeyInfoFactory." + (String)(object2 != null ? object2 : string);
            String string3 = ((Properties)serializable2).getProperty((String)object);
            if (string3 != null) {
                string2 = string3;
                serializable = serializable2;
                break;
            }
            ++n;
        }
        if (string2 == null) {
            throw new NoSuchMechanismException("Cannot find " + string + " mechanism type.");
        }
        try {
            object2 = serializable.getClass().getClassLoader();
            serializable2 = object2 != null ? ((ClassLoader)object2).loadClass(string2) : a.a(string2);
            object = (KeyInfoFactory)((Class)serializable2).newInstance();
            ((KeyInfoFactory)object).mechanismType = string;
            ((KeyInfoFactory)object).provider = serializable;
            return object;
        }
        catch (ClassCastException classCastException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " is not a " + TYPE + ".", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be found.", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be instantiated.", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be accessed.", illegalAccessException);
        }
        catch (SecurityException securityException) {
            throw new XMLSignatureException("Class '" + string2 + "' configured for " + TYPE + " " + "(provider: " + serializable.getName() + ")" + " cannot be accessed.", securityException);
        }
    }

    protected KeyInfoFactory() {
    }
}

